/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionRequest;
import com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionResult;
import com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionResult;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsResult;

/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * VPNコネクションカテゴリクライアント。<br />
 * VPNコネクション カテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyVpnConnectionAsync extends NiftyVpnConnection {

	/**
	 * 非同期でVPNコネクションを新規作成します。
	 *
	 * @param request CreateVpnConnectionリクエスト<br />
	 * &nbsp;	CreateVpnConnectionRequest#niftyRemoteVpnは利用不可<br />
	 * &nbsp;	CreateVpnConnectionRequest#optionsは利用不可
	 * @return 非同期処理結果
	 */
	public Future<CreateVpnConnectionResult> createVpnConnectionAsync(CreateVpnConnectionRequest request);


	/**
	 * 非同期で指定したVPNコネクションを削除します。
	 *
	 * @param request DeleteVpnConnectionリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DeleteVpnConnectionResult> deleteVpnConnectionAsync(DeleteVpnConnectionRequest request);


	/**
	 * 非同期でVPNコネクションの情報を取得します。
	 *
	 * @param request DescribeVpnConnectionsリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(DescribeVpnConnectionsRequest request);

}