/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection;

import com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionRequest;
import com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionResult;
import com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionResult;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * VPNコネクション カテゴリ クライアント。<br />
 * VPNコネクション カテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyVpnConnection {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * VPNコネクションを新規作成します。
	 *
	 * @param request CreateVpnConnectionリクエスト<br />
	 * &nbsp;	CreateVpnConnectionRequest#niftyRemoteVpnは利用不可<br />
	 * &nbsp;	CreateVpnConnectionRequest#optionsは利用不可
	 * @return CreateVpnConnection処理結果
	 */
	public CreateVpnConnectionResult createVpnConnection(CreateVpnConnectionRequest request);

	/**
	 * 指定したVPNコネクションを削除します。
	 *
	 * @param request DeleteVpnConnectionリクエスト
	 * @return DeleteVpnConnection処理結果
	 */
	public DeleteVpnConnectionResult deleteVpnConnection(DeleteVpnConnectionRequest request);

	/**
	 * VPNコネクションの情報を取得します。
	 *
	 * @param request DescribeVpnConnectionsリクエスト
	 * @return DescribeVpnConnections処理結果
	 */
	public DescribeVpnConnectionsResult describeVpnConnections(DescribeVpnConnectionsRequest request);
}