/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.usage.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * スナップショット利用情報クラス。<br />
 * このクラスはスナップショット利用情報を格納します。
 */
public class UsageSnapshot {

	/** スナップショット利用情報 */
	@XStreamAlias("snapShot")
	private UsageDetail snapShot;

	/**
	 * スナップショット利用情報を取得します。
	 *
	 * @return スナップショット利用情報
	 */
	public UsageDetail getSnapShot() {
		return snapShot;
	}

	/**
	 * スナップショット利用情報を設定します。
	 *
	 * @param snapShot スナップショット利用情報
	 */
	public void setSnapShot(UsageDetail snapShot) {
		this.snapShot = snapShot;
	}

	/**
	 * スナップショット利用情報を設定し、自オブジェクトを返します。
	 *
	 * @param snapShot スナップショット利用情報
	 * @return 自オブジェクト
	 */
	public UsageSnapshot withSnapShot(UsageDetail snapShot) {
		setSnapShot(snapShot);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[snapShot=");
		builder.append(snapShot);
		builder.append("]");
		return builder.toString();
	}
}
