/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.usage.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * プライベートネットワーク利用情報クラス。<br />
 * このクラスはプライベートネットワーク利用情報を格納します。
 */
public class UsagePrivateNetwork {

	/** プライベートネットワーク月額利用情報 */
	@XStreamAlias("privateNetworkMonthlyRate")
	private UsageDetail privateNetworkMonthlyRate;

	/** プライベートネットワーク従量利用情報 */
	@XStreamAlias("privateNetworkMeasuredRate")
	private UsageDetail privateNetworkMeasuredRate;

	/**
	 * プライベートネットワーク月額利用情報を取得します。
	 *
	 * @return プライベートネットワーク月額利用情報
	 */
	public UsageDetail getPrivateNetworkMonthlyRate() {
		return privateNetworkMonthlyRate;
	}

	/**
	 * プライベートネットワーク月額利用情報を設定します。
	 *
	 * @param privateNetworkMonthlyRate プライベートネットワーク月額利用情報
	 */
	public void setPrivateNetworkMonthlyRate(UsageDetail privateNetworkMonthlyRate) {
		this.privateNetworkMonthlyRate = privateNetworkMonthlyRate;
	}

	/**
	 * プライベートネットワーク月額利用情報を設定し、自オブジェクトを返します。
	 *
	 * @param privateNetworkMonthlyRate プライベートネットワーク月額利用情報
	 * @return 自オブジェクト
	 */
	public UsagePrivateNetwork withPrivateNetworkMonthlyRate(UsageDetail privateNetworkMonthlyRate) {
		setPrivateNetworkMonthlyRate(privateNetworkMonthlyRate);
		return this;
	}

	/**
	 * プライベートネットワーク従量利用情報を取得します。
	 *
	 * @return プライベートネットワーク従量利用情報
	 */
	public UsageDetail getPrivateNetworkMeasuredRate() {
		return privateNetworkMeasuredRate;
	}

	/**
	 * プライベートネットワーク従量利用情報を設定します。
	 *
	 * @param privateNetworkMeasuredRate プライベートネットワーク従量利用情報
	 */
	public void setPrivateNetworkMeasuredRate(UsageDetail privateNetworkMeasuredRate) {
		this.privateNetworkMeasuredRate = privateNetworkMeasuredRate;
	}

	/**
	 * プライベートネットワーク従量利用情報を設定し、自オブジェクトを返します。
	 *
	 * @param privateNetworkMeasuredRate プライベートネットワーク従量利用情報
	 * @return 自オブジェクト
	 */
	public UsagePrivateNetwork withPrivateNetworkMeasuredRate(UsageDetail privateNetworkMeasuredRate) {
		setPrivateNetworkMeasuredRate(privateNetworkMeasuredRate);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[privateNetworkMonthlyRate=");
		builder.append(privateNetworkMonthlyRate);
		builder.append(", privateNetworkMeasuredRate=");
		builder.append(privateNetworkMeasuredRate);
		builder.append("]");
		return builder.toString();
	}
}
