/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.usage.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.usage.model.transform.UsageDetailSetConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * ネットワークインターフェース利用情報クラス。<br />
 * このクラスはネットワークインターフェース利用情報を格納します。
 */
public class NetworkInterface {

    /** ネットワークインターフェース月額利用情報リスト */
    @XStreamAlias("networkInterfaceMonthlyRateSet")
    @XStreamConverter(UsageDetailSetConverter.class)
    private List<UsageDetail> networkInterfaceMonthlyRates;

    /**
     * ネットワークインターフェース月額利用情報リストを取得します。
     *
     * @return ネットワークインターフェース月額利用情報リスト
     */
    public List<UsageDetail> getNetworkInterfaceMonthlyRates() {
        return networkInterfaceMonthlyRates;
    }

    /**
     * ネットワークインターフェース月額利用情報リストを設定します。
     *
     * @param networkInterfaceMonthlyRates
     *            ネットワークインターフェース月額利用情報リスト
     */
    public void setNetworkInterfaceMonthlyRates(List<UsageDetail> networkInterfaceMonthlyRates) {
        this.networkInterfaceMonthlyRates = networkInterfaceMonthlyRates;
    }

    /**
     * ネットワークインターフェース月額利用情報の配列を設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceMonthlyRates
     *            ネットワークインターフェース月額利用情報の配列
     * @return 自オブジェクト
     */
    public NetworkInterface withRouterMonthlyRates(UsageDetail... networkInterfaceMonthlyRates) {
        if (this.networkInterfaceMonthlyRates == null)
            this.networkInterfaceMonthlyRates = new ArrayList<UsageDetail>();
        for (UsageDetail networkInterfaceMonthlyRate : networkInterfaceMonthlyRates) {
            getNetworkInterfaceMonthlyRates().add(networkInterfaceMonthlyRate);
        }
        return this;
    }

    /**
     * ネットワークインターフェース月額利用情報リストを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceMonthlyRates
     *            ネットワークインターフェース月額利用情報リスト
     * @return 自オブジェクト
     */
    public NetworkInterface
        withRouterMonthlyRates(Collection<UsageDetail> networkInterfaceMonthlyRates) {
        if (this.networkInterfaceMonthlyRates == null)
            this.networkInterfaceMonthlyRates = new ArrayList<UsageDetail>();
        if (networkInterfaceMonthlyRates != null) {
            getNetworkInterfaceMonthlyRates().addAll(networkInterfaceMonthlyRates);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[networkInterfaceMonthlyRates=");
        builder.append(networkInterfaceMonthlyRates);
        builder.append("]");
        return builder.toString();
    }

}
