/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.tools;

import com.nifty.cloud.sdk.ErrorResult;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Response;
import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;

/**
 * XMLユーティリティクラス。<br />
 * XMLをJavaクラスへ変換するクラスです。
 */
public final class XmlUtils {

	/**
	 * XMLからJava Beanへ変換を行います。
	 *
	 * @param xml 変換を行うXML
	 * @param clazz 変換後のClass
	 * @return 変換されたJavaオブジェクト
	 */
	public static Result xml2Bean(String xml, Class<? extends Result> clazz) {

		try {

			Class<?> targetClass = clazz;
			Xml2Response proxyClass = clazz.getAnnotation(Xml2Response.class);
			if (proxyClass != null) {
				targetClass = proxyClass.response();
			}
			XStream xstream = new XStream() {
				   @Override
				   protected void setupSecurity() {
				      addPermission(AnyTypePermission.ANY);
				   }
			};
			xstream.processAnnotations(new Class[] {targetClass, ErrorResult.class});
			xstream.ignoreUnknownElements();
			Object result = xstream.fromXML(xml);
			return (Result) ((proxyClass != null && result instanceof Response) ? ((Response)result).getResult() : result);

		} catch (Exception e) {
			throw new NiftyClientException(e);
		}
	}

}
