/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model.transform;

import com.nifty.cloud.sdk.snapshot.model.SnapshotInfo;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import java.util.ArrayList;
import java.util.List;

/**
 * SnapshotInfoSetType変換クラス。<br />
 * このクラスはレスポンスXMLのsnapshotInfoSet要素からSnapshotInfoクラスのリストを生成します。
 */
public class SnapshotInfoSetConverter implements Converter {

	private static final String ELEMENT_INSTANCE_SNAPSHOT_ID = "instanceSnapshotId";
	private static final String ELEMENT_SNAPSHOT_NAME = "snapshotName";
	private static final String ELEMENT_POWER_STATUS = "powerStatus";
	private static final String ELEMENT_MEMO = "memo";
	private static final String ELEMENT_CREATED_TIME = "createdTime";
	private static final String ELEMENT_UPDATED_TIME = "updatedTime";
	private static final String ELEMENT_EXPIRED_TIME = "expiredTime";
	private static final String ELEMENT_INSTANCE_ID = "instanceId";
	private static final String ELEMENT_STATUS = "status";
	private static final String ELEMENT_DIFFERENCE = "difference";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * snapshotInfoSetをList<SnapshotInfo>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<SnapshotInfo>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<SnapshotInfo> snapshotInfos = new ArrayList<SnapshotInfo>();
		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			SnapshotInfo snapshotInfo = new SnapshotInfo();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_INSTANCE_SNAPSHOT_ID)) {
					snapshotInfo.setInstanceSnapshotId(reader.getValue());
				} else if (name.equals(ELEMENT_SNAPSHOT_NAME)) {
					snapshotInfo.setSnapshotName(reader.getValue());
				} else if (name.equals(ELEMENT_POWER_STATUS)) {
					snapshotInfo.setPowerStatus(reader.getValue());
				} else if (name.equals(ELEMENT_MEMO)) {
					snapshotInfo.setMemo(reader.getValue());
				} else if (name.equals(ELEMENT_CREATED_TIME)) {
					snapshotInfo.setCreatedTime(reader.getValue());
				} else if (name.equals(ELEMENT_UPDATED_TIME)) {
					snapshotInfo.setUpdatedTime(reader.getValue());
				} else if (name.equals(ELEMENT_EXPIRED_TIME)) {
					snapshotInfo.setExpiredTime(reader.getValue());
				} else if (name.equals(ELEMENT_INSTANCE_ID)) {
					snapshotInfo.setInstanceId(reader.getValue());
				} else if (name.equals(ELEMENT_STATUS)) {
					snapshotInfo.setStatus(reader.getValue());
				} else if (name.equals(ELEMENT_DIFFERENCE)) {
					snapshotInfo.setDifference(reader.getValue());
				}

				reader.moveUp();
			}
			snapshotInfos.add(snapshotInfo);
			reader.moveUp();
		}

		return snapshotInfos;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
