/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

/**
 * サーバー設定情報クラス。<br />
 * このクラスはサーバー設定情報を格納します。
 *
 */
public class SnapshotInstance {

	/** サーバー名 */
	private String instanceId;

	/** サーバーユニークID */
	private String instanceUniqueId;

	/** サーバーのステータス */
	private String instanceState;

	/**
	 * サーバー名を取得します。
	 *
	 * @return サーバー名
	 */
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * サーバー名を設定します。
	 *
	 * @param instanceId サーバー名
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * サーバー名を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId サーバー名
	 * @return 自オブジェクト
	 */
	public SnapshotInstance withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * サーバーユニークIDを取得します。
	 *
	 * @return サーバーユニークID
	 */
	public String getInstanceUniqueId() {
		return instanceUniqueId;
	}

	/**
	 * サーバーユニークIDを設定します。
	 *
	 * @param instanceUniqueId サーバーユニークID
	 */
	public void setInstanceUniqueId(String instanceUniqueId) {
		this.instanceUniqueId = instanceUniqueId;
	}

	/**
	 * サーバーユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param instanceUniqueId サーバーユニークID
	 * @return 自オブジェクト
	 */
	public SnapshotInstance withInstanceUniqueId(String instanceUniqueId) {
		setInstanceUniqueId(instanceUniqueId);
		return this;
	}

	/**
	 * サーバーのステータスを取得します。
	 *
	 * @return サーバーのステータス
	 */
	public String getInstanceState() {
		return instanceState;
	}

	/**
	 * サーバーのステータスを設定します。
	 *
	 * @param instanceState サーバーのステータス
	 */
	public void setInstanceState(String instanceState) {
		this.instanceState = instanceState;
	}

	/**
	 * サーバーのステータスを設定し、自オブジェクトを返します。
	 *
	 * @param instanceState サーバーのステータス
	 * @return 自オブジェクト
	 */
	public SnapshotInstance withInstanceState(String instanceState) {
		setInstanceState(instanceState);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceId=");
		builder.append(instanceId);
		builder.append(", instanceUniqueId=");
		builder.append(instanceUniqueId);
		builder.append(", instanceState=");
		builder.append(instanceState);
		builder.append("]");
		return builder.toString();
	}
}
