/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

/**
 * スナップショット情報クラス。<br />
 * このクラスはスナップショット情報を格納します。
 *
 */
public class SnapshotInfo {

	/** スナップショットID */
	private String instanceSnapshotId;

	/** スナップショット名 */
	private String snapshotName;

	/** 電源状態 */
	private String powerStatus;

	/** メモ */
	private String memo;

	/** 登録日時 */
	private String createdTime;

	/** 更新日時 */
	private String updatedTime;

	/** 保持期限 */
	private String expiredTime;

	/** 紐づくサーバー名 */
	private String instanceId;

	/** ステータス */
	private String status;

	/** スナップショット更新量 */
	private String difference;

	/**
	 * スナップショットIDを取得します。
	 *
	 * @return スナップショットID
	 */
	public String getInstanceSnapshotId() {
		return instanceSnapshotId;
	}

	/**
	 * スナップショットIDを設定します。
	 *
	 * @param instanceSnapshotId スナップショットID
	 */
	public void setInstanceSnapshotId(String instanceSnapshotId) {
		this.instanceSnapshotId = instanceSnapshotId;
	}

	/**
	 * スナップショットIDを設定し、自オブジェクトを返します。
	 *
	 * @param instanceSnapshotId スナップショットID
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withInstanceSnapshotId(String instanceSnapshotId) {
		setInstanceSnapshotId(instanceSnapshotId);
		return this;
	}

	/**
	 * スナップショット名を取得します。
	 *
	 * @return スナップショット名
	 */
	public String getSnapshotName() {
		return snapshotName;
	}

	/**
	 * スナップショット名を設定します。
	 *
	 * @param snapshotName スナップショット名
	 */
	public void setSnapshotName(String snapshotName) {
		this.snapshotName = snapshotName;
	}

	/**
	 * スナップショット名を設定し、自オブジェクトを返します。
	 *
	 * @param snapshotName スナップショット名
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withSnapshotName(String snapshotName) {
		setSnapshotName(snapshotName);
		return this;
	}

	/**
	 * 電源状態を取得します。
	 *
	 * @return 電源状態
	 */
	public String getPowerStatus() {
		return powerStatus;
	}

	/**
	 * 電源状態を設定します。
	 *
	 * @param powerStatus 電源状態
	 */
	public void setPowerStatus(String powerStatus) {
		this.powerStatus = powerStatus;
	}

	/**
	 * 電源状態を設定し、自オブジェクトを返します。
	 *
	 * @param powerStatus 電源状態
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withPowerStatus(String powerStatus) {
		setPowerStatus(powerStatus);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getMemo() {
		return memo;
	}

	/**
	 * メモを設定します。
	 *
	 * @param memo メモ
	 */
	public void setMemo(String memo) {
		this.memo = memo;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param memo メモ
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withMemo(String memo) {
		setMemo(memo);
		return this;
	}

	/**
	 * 登録日時を取得します。
	 *
	 * @return 登録日時
	 */
	public String getCreatedTime() {
		return createdTime;
	}

	/**
	 * 登録日時を設定します。
	 *
	 * @param createdTime 登録日時
	 */
	public void setCreatedTime(String createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * 登録日時を設定し、自オブジェクトを返します。
	 *
	 * @param createdTime 登録日時
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withCreatedTime(String createdTime) {
		setCreatedTime(createdTime);
		return this;
	}

	/**
	 * 更新日時を取得します。
	 *
	 * @return 更新日時
	 */
	public String getUpdatedTime() {
		return updatedTime;
	}

	/**
	 * 更新日時を設定します。
	 *
	 * @param updatedTime 更新日時
	 */
	public void setUpdatedTime(String updatedTime) {
		this.updatedTime = updatedTime;
	}

	/**
	 * 更新日時を設定し、自オブジェクトを返します。
	 *
	 * @param updatedTime 更新日時
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withUpdatedTime(String updatedTime) {
		setUpdatedTime(updatedTime);
		return this;
	}

	/**
	 * 保持期限を取得します。
	 *
	 * @return 保持期限
	 */
	public String getExpiredTime() {
		return expiredTime;
	}

	/**
	 * 保持期限を設定します。
	 *
	 * @param expiredTime 保持期限
	 */
	public void setExpiredTime(String expiredTime) {
		this.expiredTime = expiredTime;
	}

	/**
	 * 保持期限を設定し、自オブジェクトを返します。
	 *
	 * @param expiredTime 保持期限
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withExpiredTime(String expiredTime) {
		setExpiredTime(expiredTime);
		return this;
	}

	/**
	 * 紐づくサーバー名を取得します。
	 *
	 * @return 紐づくサーバー名
	 */
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * 紐づくサーバー名を設定します。
	 *
	 * @param instanceId 紐づくサーバー名
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * 紐づくサーバー名を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId 紐づくサーバー名
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * ステータスを取得します。
	 *
	 * @return ステータス
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * ステータスを設定します。
	 *
	 * @param status ステータス
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * ステータスを設定し、自オブジェクトを返します。
	 *
	 * @param status ステータス
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withStatus(String status) {
		setStatus(status);
		return this;
	}

	/**
	 * スナップショット更新量を取得します。
	 *
	 * @return スナップショット更新量
	 */
	public String getDifference() {
		return difference;
	}

	/**
	 * スナップショット更新量を設定します。
	 *
	 * @param difference スナップショット更新量
	 */
	public void setDifference(String difference) {
		this.difference = difference;
	}

	/**
	 * スナップショット更新量を設定し、自オブジェクトを返します。
	 *
	 * @param difference スナップショット更新量
	 * @return 自オブジェクト
	 */
	public SnapshotInfo withDifference(String difference) {
		setDifference(difference);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceSnapshotId=");
		builder.append(instanceSnapshotId);
		builder.append(", snapshotName=");
		builder.append(snapshotName);
		builder.append(", powerStatus=");
		builder.append(powerStatus);
		builder.append(", memo=");
		builder.append(memo);
		builder.append(", createdTime=");
		builder.append(createdTime);
		builder.append(", updatedTime=");
		builder.append(updatedTime);
		builder.append(", expiredTime=");
		builder.append(expiredTime);
		builder.append(", instanceId=");
		builder.append(instanceId);
		builder.append(", status=");
		builder.append(status);
		builder.append(", difference=");
		builder.append(difference);
		builder.append("]");
		return builder.toString();
	}
}
