/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyModifyInstanceSnapshotAttributeリクエストクラス。<br />
 * このクラスはNiftyModifyInstanceSnapshotAttributeへのリクエストを構築します。
 *
 */
@Action("NiftyModifyInstanceSnapshotAttribute")
public class NiftyModifyInstanceSnapshotAttributeRequest implements Request {

	/** スナップショットID */
	private String instanceSnapshotId;

	/** スナップショット名 */
	private String snapshotName;

	/** 属性 */
	private String attribute;

	/** メモ */
	private String value;

	/**
	 * スナップショットIDを取得します。
	 *
	 * @return スナップショットID
	 */
	@Query(name="InstanceSnapshotId")
	public String getInstanceSnapshotId() {
		return instanceSnapshotId;
	}

	/**
	 * スナップショットIDを設定します。
	 *
	 * @param instanceSnapshotId スナップショットID
	 */
	public void setInstanceSnapshotId(String instanceSnapshotId) {
		this.instanceSnapshotId = instanceSnapshotId;
	}

	/**
	 * スナップショットIDを設定し、自オブジェクトを返します。
	 *
	 * @param instanceSnapshotId スナップショットID
	 * @return 自オブジェクト
	 */
	public NiftyModifyInstanceSnapshotAttributeRequest withInstanceSnapshotId(String instanceSnapshotId) {
		setInstanceSnapshotId(instanceSnapshotId);
		return this;
	}

	/**
	 * スナップショット名を取得します。
	 *
	 * @return スナップショット名
	 */
	@Query(name="SnapshotName")
	public String getSnapshotName() {
		return snapshotName;
	}

	/**
	 * スナップショット名を設定します。
	 *
	 * @param snapshotName スナップショット名
	 */
	public void setSnapshotName(String snapshotName) {
		this.snapshotName = snapshotName;
	}

	/**
	 * スナップショット名を設定し、自オブジェクトを返します。
	 *
	 * @param snapshotName スナップショット名
	 * @return 自オブジェクト
	 */
	public NiftyModifyInstanceSnapshotAttributeRequest withSnapshotName(String snapshotName) {
		setSnapshotName(snapshotName);
		return this;
	}

	/**
	 * 属性を取得します。
	 *
	 * @return 属性
	 */
	@Query(name="Attribute")
	public String getAttribute() {
		return attribute;
	}

	/**
	 * 属性を設定します。
	 *
	 * @param attribute 属性
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	/**
	 * 属性を設定し、自オブジェクトを返します。
	 *
	 * @param attribute 属性
	 * @return 自オブジェクト
	 */
	public NiftyModifyInstanceSnapshotAttributeRequest withAttribute(String attribute) {
		setAttribute(attribute);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="Value")
	public String getValue() {
		return value;
	}

	/**
	 * メモを設定します。
	 *
	 * @param value メモ
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param value メモ
	 * @return 自オブジェクト
	 */
	public NiftyModifyInstanceSnapshotAttributeRequest withValue(String value) {
		setValue(value);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceSnapshotId=");
		builder.append(instanceSnapshotId);
		builder.append(", snapshotName=");
		builder.append(snapshotName);
		builder.append(", attribute=");
		builder.append(attribute);
		builder.append(", value=");
		builder.append(value);
		builder.append("]");
		return builder.toString();
	}
}
