/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeInstanceSnapshotsリクエストクラス。<br />
 * このクラスはNiftyDescribeInstanceSnapshotsへのリクエストを構築します。
 *
 */
@Action("NiftyDescribeInstanceSnapshots")
public class NiftyDescribeInstanceSnapshotsRequest implements Request {

	/** スナップショット情報 */
	private List<NiftyDescribeInstanceSnapshot> niftyDescribeInstanceSnapshots;

	/**
	 * スナップショット情報を取得します。
	 *
	 * @return スナップショット情報
	 */
	@Query(name="")
	public List<NiftyDescribeInstanceSnapshot> getNiftyDescribeInstanceSnapshots() {
		return niftyDescribeInstanceSnapshots;
	}

	/**
	 * スナップショット情報を設定します。
	 *
	 * @param niftyDescribeInstanceSnapshots スナップショット情報
	 */
	public void setNiftyDescribeInstanceSnapshots(List<NiftyDescribeInstanceSnapshot> niftyDescribeInstanceSnapshots) {
		this.niftyDescribeInstanceSnapshots = niftyDescribeInstanceSnapshots;
	}

	/**
	 * スナップショット情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param niftyDescribeInstanceSnapshots スナップショット情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeInstanceSnapshotsRequest withNiftyDescribeInstanceSnapshots(NiftyDescribeInstanceSnapshot ... niftyDescribeInstanceSnapshots) {
		if (this.niftyDescribeInstanceSnapshots == null) this.niftyDescribeInstanceSnapshots = new ArrayList<NiftyDescribeInstanceSnapshot>();
		for (NiftyDescribeInstanceSnapshot niftyDescribeInstanceSnapshot : niftyDescribeInstanceSnapshots) {
			getNiftyDescribeInstanceSnapshots().add(niftyDescribeInstanceSnapshot);
		}
		return this;
	}

	/**
	 * スナップショット情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param niftyDescribeInstanceSnapshots スナップショット情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeInstanceSnapshotsRequest withNiftyDescribeInstanceSnapshots(Collection<NiftyDescribeInstanceSnapshot> niftyDescribeInstanceSnapshots) {
		if (this.niftyDescribeInstanceSnapshots == null) this.niftyDescribeInstanceSnapshots = new ArrayList<NiftyDescribeInstanceSnapshot>();
		if (niftyDescribeInstanceSnapshots != null) {
			getNiftyDescribeInstanceSnapshots().addAll(niftyDescribeInstanceSnapshots);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[niftyDescribeInstanceSnapshots=");
		builder.append(niftyDescribeInstanceSnapshots);
		builder.append("]");
		return builder.toString();
	}
}
