/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * スナップショット情報取得情報クラス。<br />
 * このクラスはスナップショット情報取得情報を格納します。
 *
 */
public class NiftyDescribeInstanceSnapshot {

	/** スナップショットID */
	private String instanceSnapshotId;

	/** スナップショット名 */
	private String snapshotName;

	/**
	 * スナップショットIDを取得します。
	 *
	 * @return スナップショットID
	 */
	@Query(name="InstanceSnapshotId", reverseSequence=true)
	public String getInstanceSnapshotId() {
		return instanceSnapshotId;
	}

	/**
	 * スナップショットIDを設定します。
	 *
	 * @param instanceSnapshotId スナップショットID
	 */
	public void setInstanceSnapshotId(String instanceSnapshotId) {
		this.instanceSnapshotId = instanceSnapshotId;
	}

	/**
	 * スナップショットIDを設定し、自オブジェクトを返します。
	 *
	 * @param instanceSnapshotId スナップショットID
	 * @return 自オブジェクト
	 */
	public NiftyDescribeInstanceSnapshot withInstanceSnapshotId(String instanceSnapshotId) {
		setInstanceSnapshotId(instanceSnapshotId);
		return this;
	}

	/**
	 * スナップショット名を取得します。
	 *
	 * @return スナップショット名
	 */
	@Query(name="SnapshotName", reverseSequence=true)
	public String getSnapshotName() {
		return snapshotName;
	}

	/**
	 * スナップショット名を設定します。
	 *
	 * @param snapshotName スナップショット名
	 */
	public void setSnapshotName(String snapshotName) {
		this.snapshotName = snapshotName;
	}

	/**
	 * スナップショット名を設定し、自オブジェクトを返します。
	 *
	 * @param snapshotName スナップショット名
	 * @return 自オブジェクト
	 */
	public NiftyDescribeInstanceSnapshot withSnapshotName(String snapshotName) {
		setSnapshotName(snapshotName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceSnapshotId=");
		builder.append(instanceSnapshotId);
		builder.append(", snapshotName=");
		builder.append(snapshotName);
		builder.append("]");
		return builder.toString();
	}
}
