/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.snapshot.model.transform.NiftyDeleteInstanceSnapshotResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDeleteInstanceSnapshot処理結果クラス。<br />
 * このクラスはNiftyDeleteInstanceSnapshotのレスポンスを格納します。
 */
@XStreamAlias("NiftyDeleteInstanceSnapshotResponse")
@XStreamConverter(NiftyDeleteInstanceSnapshotResultConverter.class)
public class NiftyDeleteInstanceSnapshotResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** スナップショット情報 */
	private List<SnapshotInfo> snapshots;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDeleteInstanceSnapshotResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * スナップショット情報を取得します。
	 *
	 * @return スナップショット情報
	 */
	public List<SnapshotInfo> getSnapshots() {
		return snapshots;
	}

	/**
	 * スナップショット情報を設定します。
	 *
	 * @param snapshots スナップショット情報
	 */
	public void setSnapshots(List<SnapshotInfo> snapshots) {
		this.snapshots = snapshots;
	}

	/**
	 * スナップショット情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param snapshots スナップショット情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDeleteInstanceSnapshotResult withSnapshots(SnapshotInfo ... snapshots) {
		if (this.snapshots == null) this.snapshots = new ArrayList<SnapshotInfo>();
		for (SnapshotInfo snapshot : snapshots) {
			getSnapshots().add(snapshot);
		}
		return this;
	}

	/**
	 * スナップショット情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param snapshots スナップショット情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDeleteInstanceSnapshotResult withSnapshots(Collection<SnapshotInfo> snapshots) {
		if (this.snapshots == null) this.snapshots = new ArrayList<SnapshotInfo>();
		if (snapshots != null) {
			getSnapshots().addAll(snapshots);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", snapshots=");
		builder.append(snapshots);
		builder.append("]");
		return builder.toString();
	}
}
