/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyCreateInstanceSnapshotリクエストクラス。<br />
 * このクラスはNiftyCreateInstanceSnapshotへのリクエストを構築します。
 *
 */
@Action("NiftyCreateInstanceSnapshot")
public class NiftyCreateInstanceSnapshotRequest implements Request {

	/** サーバー名 */
	private String instanceId;

	/** スナップショット名 */
	private String snapshotName;

	/** メモ */
	private String description;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyCreateInstanceSnapshotRequest() {
	}

	/**
	 * サーバー名,スナップショット名を指定し、NiftyCreateInstanceSnapshotRequestを構築します。
	 *
	 * @param instanceId サーバー名
	 * @param snapshotName スナップショット名
	 */
	public NiftyCreateInstanceSnapshotRequest(String instanceId, String snapshotName) {
		this.instanceId = instanceId;
		this.snapshotName = snapshotName;
	}

	/**
	 * サーバー名を取得します。
	 *
	 * @return サーバー名
	 */
	@Query(name="InstanceId", require=true)
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * サーバー名を設定します。
	 *
	 * @param instanceId サーバー名
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * サーバー名を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId サーバー名
	 * @return 自オブジェクト
	 */
	public NiftyCreateInstanceSnapshotRequest withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * スナップショット名を取得します。
	 *
	 * @return スナップショット名
	 */
	@Query(name="SnapshotName", require=true)
	public String getSnapshotName() {
		return snapshotName;
	}

	/**
	 * スナップショット名を設定します。
	 *
	 * @param snapshotName スナップショット名
	 */
	public void setSnapshotName(String snapshotName) {
		this.snapshotName = snapshotName;
	}

	/**
	 * スナップショット名を設定し、自オブジェクトを返します。
	 *
	 * @param snapshotName スナップショット名
	 * @return 自オブジェクト
	 */
	public NiftyCreateInstanceSnapshotRequest withSnapshotName(String snapshotName) {
		setSnapshotName(snapshotName);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="Description")
	public String getDescription() {
		return description;
	}

	/**
	 * メモを設定します。
	 *
	 * @param description メモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param description メモ
	 * @return 自オブジェクト
	 */
	public NiftyCreateInstanceSnapshotRequest withDescription(String description) {
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceId=");
		builder.append(instanceId);
		builder.append(", snapshotName=");
		builder.append(snapshotName);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
