/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * スナップショットカテゴリ クライアント。<br />
 * スナップショット カテゴリの同期クライアントの具象クラスです。
 *
 */
public class NiftySnapshotClient extends BaseClient implements NiftySnapshot {

	/**
	 * 認証情報を指定し、スナップショットカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftySnapshotClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、スナップショットカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftySnapshotClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.snapshot.NiftySnapshot#niftyCreateInstanceSnapshot(com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotRequest)
	 */
	@Override
	public NiftyCreateInstanceSnapshotResult niftyCreateInstanceSnapshot(NiftyCreateInstanceSnapshotRequest request) {
		return (NiftyCreateInstanceSnapshotResult) client.execute(request, NiftyCreateInstanceSnapshotResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.snapshot.NiftySnapshot#niftyModifyInstanceSnapshotAttribute(com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeRequest)
	 */
	@Override
	public NiftyModifyInstanceSnapshotAttributeResult niftyModifyInstanceSnapshotAttribute(NiftyModifyInstanceSnapshotAttributeRequest request) {
		return (NiftyModifyInstanceSnapshotAttributeResult) client.execute(request, NiftyModifyInstanceSnapshotAttributeResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.snapshot.NiftySnapshot#niftyDescribeInstanceSnapshots(com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsRequest)
	 */
	@Override
	public NiftyDescribeInstanceSnapshotsResult niftyDescribeInstanceSnapshots(NiftyDescribeInstanceSnapshotsRequest request) {
		return (NiftyDescribeInstanceSnapshotsResult) client.execute(request, NiftyDescribeInstanceSnapshotsResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.snapshot.NiftySnapshot#niftyDeleteInstanceSnapshot(com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotRequest)
	 */
	@Override
	public NiftyDeleteInstanceSnapshotResult niftyDeleteInstanceSnapshot(NiftyDeleteInstanceSnapshotRequest request) {
		return (NiftyDeleteInstanceSnapshotResult) client.execute(request, NiftyDeleteInstanceSnapshotResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.snapshot.NiftySnapshot#niftyRestoreInstanceSnapshot(com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotRequest)
	 */
	@Override
	public NiftyRestoreInstanceSnapshotResult niftyRestoreInstanceSnapshot(NiftyRestoreInstanceSnapshotRequest request) {
		return (NiftyRestoreInstanceSnapshotResult) client.execute(request, NiftyRestoreInstanceSnapshotResult.class);
	}
}