/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * スナップショットカテゴリクライアント。<br />
 * スナップショット カテゴリの非同期クライアントのインタフェースです。
 *
 */
public interface NiftySnapshotAsync extends NiftySnapshot {

	/**
	 * 非同期で指定したサーバーに対してスナップショットを取得します。
	 *
	 * @param request NiftyCreateInstanceSnapshotリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateInstanceSnapshotResult> niftyCreateInstanceSnapshotAsync(NiftyCreateInstanceSnapshotRequest request);


	/**
	 * 非同期で指定したスナップショットを更新します。
	 *
	 * @param request NiftyModifyInstanceSnapshotAttributeリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyModifyInstanceSnapshotAttributeResult> niftyModifyInstanceSnapshotAttributeAsync(NiftyModifyInstanceSnapshotAttributeRequest request);


	/**
	 * 非同期でスナップショットの情報を取得します。
	 *
	 * @param request NiftyDescribeInstanceSnapshotsリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeInstanceSnapshotsResult> niftyDescribeInstanceSnapshotsAsync(NiftyDescribeInstanceSnapshotsRequest request);


	/**
	 * 非同期で指定したスナップショットを削除します。
	 *
	 * @param request NiftyDeleteInstanceSnapshotリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteInstanceSnapshotResult> niftyDeleteInstanceSnapshotAsync(NiftyDeleteInstanceSnapshotRequest request);


	/**
	 * 非同期で指定したスナップショットをリストアします。
	 *
	 * @param request NiftyRestoreInstanceSnapshotリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyRestoreInstanceSnapshotResult> niftyRestoreInstanceSnapshotAsync(NiftyRestoreInstanceSnapshotRequest request);

}