/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.snapshot;

import com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyCreateInstanceSnapshotResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDeleteInstanceSnapshotResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyModifyInstanceSnapshotAttributeResult;
import com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyRestoreInstanceSnapshotResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * スナップショット カテゴリ クライアント。<br />
 * スナップショット カテゴリの同期クライアントのインタフェースです。
 *
 */
public interface NiftySnapshot {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * 指定したサーバーに対してスナップショットを取得します。
	 *
	 * @param request NiftyCreateInstanceSnapshotリクエスト
	 * @return NiftyCreateInstanceSnapshot処理結果
	 */
	public NiftyCreateInstanceSnapshotResult niftyCreateInstanceSnapshot(NiftyCreateInstanceSnapshotRequest request);

	/**
	 * 指定したスナップショットを更新します。
	 *
	 * @param request NiftyModifyInstanceSnapshotAttributeリクエスト
	 * @return NiftyModifyInstanceSnapshotAttribute処理結果
	 */
	public NiftyModifyInstanceSnapshotAttributeResult niftyModifyInstanceSnapshotAttribute(NiftyModifyInstanceSnapshotAttributeRequest request);

	/**
	 * スナップショットの情報を取得します。
	 *
	 * @param request NiftyDescribeInstanceSnapshotsリクエスト
	 * @return NiftyDescribeInstanceSnapshots処理結果
	 */
	public NiftyDescribeInstanceSnapshotsResult niftyDescribeInstanceSnapshots(NiftyDescribeInstanceSnapshotsRequest request);

	/**
	 * 指定したスナップショットを削除します。
	 *
	 * @param request NiftyDeleteInstanceSnapshotリクエスト
	 * @return NiftyDeleteInstanceSnapshot処理結果
	 */
	public NiftyDeleteInstanceSnapshotResult niftyDeleteInstanceSnapshot(NiftyDeleteInstanceSnapshotRequest request);

	/**
	 * 指定したスナップショットをリストアします。
	 *
	 * @param request NiftyRestoreInstanceSnapshotリクエスト
	 * @return NiftyRestoreInstanceSnapshot処理結果
	 */
	public NiftyRestoreInstanceSnapshotResult niftyRestoreInstanceSnapshot(NiftyRestoreInstanceSnapshotRequest request);
}