/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.server.model.InstanceElasticLoadBalancerMapping;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * InstanceElasticLoadBalancerMappingResponseType変換クラス。<br />
 * このクラスはレスポンスXMLのniftyElasticLoadBalancing要素からInstanceElasticLoadBalancerMappingクラスのリストを生成します。
 *
 */
public class NiftyElasticLoadBalancingConverter implements Converter {

    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_ID = "elasticLoadBalancerId";
    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_NAME = "elasticLoadBalancerName";
    private static final String ELEMENT_PROTOCOL = "protocol";
    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_PORT = "elasticLoadBalancerPort";
    private static final String ELEMENT_INSTANCE_PORT = "instancePort";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * niftyElasticLoadBalancingをList<InstanceElasticLoadBalancerMapping>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<InstanceElasticLoadBalancerMapping>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<InstanceElasticLoadBalancerMapping> niftyElasticLoadBalancings =
            new ArrayList<InstanceElasticLoadBalancerMapping>();

        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            InstanceElasticLoadBalancerMapping instanceElasticLoadBalancerMapping =
                new InstanceElasticLoadBalancerMapping();

            while (reader.hasMoreChildren()) {
                reader.moveDown();

                name = reader.getNodeName();
                if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_ID)) {
                    instanceElasticLoadBalancerMapping.setElasticLoadBalancerId(reader.getValue());
                } else if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_NAME)) {
                    instanceElasticLoadBalancerMapping
                        .setElasticLoadBalancerName(reader.getValue());
                } else if (name.equals(ELEMENT_PROTOCOL)) {
                    instanceElasticLoadBalancerMapping.setProtocol(reader.getValue());
                } else if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_PORT)) {
                    instanceElasticLoadBalancerMapping
                        .setElasticLoadBalancerPort(new Integer(reader.getValue()));
                } else if (name.equals(ELEMENT_INSTANCE_PORT)) {
                    instanceElasticLoadBalancerMapping
                        .setInstancePort(new Integer(reader.getValue()));
                }

                reader.moveUp();
            }
            reader.moveUp();
            niftyElasticLoadBalancings.add(instanceElasticLoadBalancerMapping);
        }
        return niftyElasticLoadBalancings;
    }

    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {

        // 処理無し
    }

}
