/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;



/**
 * PrivateIpAddressesクラス。<br />
 * このクラスはPrivateIpAddresses情報を格納します。
 */
public class PrivateIpAddresses {

	/** 付替IPアドレスの関連付け情報 */
	private Association association;

	/** ネットワークインターフェースのプライマリープライベートIPであるかどうか */
	private Boolean primary;

	/** プライベートDNS名 */
	private String privateDnsName;

	/** ネットワークインターフェースのプライベートIP */
	private String privateIpAddress;


	/**
	 * 付替IPアドレスの関連付け情報を取得します。
	 *
	 * @return 付替IPアドレスの関連付け情報
	 */
	public Association getAssociation() {
		return association;
	}
	/**
	 * 付替IPアドレスの関連付け情報を設定します。
	 *
	 * @param association 付替IPアドレスの関連付け情報
	 */
	public void setAssociation(Association association) {
		this.association = association;
	}
	/**
	 * 付替IPアドレスの関連付け情報を設定し、自オブジェクトを返します。
	 *
	 * @param association 付替IPアドレスの関連付け情報
	 * @return 自オブジェクト
	 */
	public PrivateIpAddresses withAssociation(Association association) {
		setAssociation(association);
		return this;
	}

	/**
	 * ネットワークインターフェースのプライマリープライベートIPであるかどうかを取得します。
	 *
	 * @return ネットワークインターフェースのプライマリープライベートIPであるかどうか
	 */
	public Boolean getPrimary() {
		return primary;
	}
	/**
	 * ネットワークインターフェースのプライマリープライベートIPであるかどうかを設定します。
	 *
	 * @param primary ネットワークインターフェースのプライマリープライベートIPであるかどうか
	 */
	public void setPrimary(Boolean primary) {
		this.primary = primary;
	}
	/**
	 * ネットワークインターフェースのプライマリープライベートIPであるかどうかを設定し、自オブジェクトを返します。
	 *
	 * @param primary ネットワークインターフェースのプライマリープライベートIPであるかどうか
	 * @return 自オブジェクト
	 */
	public PrivateIpAddresses withPrimary(Boolean primary) {
		setPrimary(primary);
		return this;
	}

	/**
	 * プライベートDNS名を取得します。
	 *
	 * @return プライベートDNS名
	 */
	public String getPrivateDnsName() {
		return privateDnsName;
	}
	/**
	 * プライベートDNS名を設定します。
	 *
	 * @param privateDnsName プライベートDNS名
	 */
	public void setPublicDnsName(String privateDnsName) {
		this.privateDnsName = privateDnsName;
	}
	/**
	 * プライベートDNS名を設定し、自オブジェクトを返します。
	 *
	 * @param privateDnsName プライベートDNS名
	 * @return 自オブジェクト
	 */
	public PrivateIpAddresses withPublicDnsName(String privateDnsName) {
		setPublicDnsName(privateDnsName);
		return this;
	}

	/**
	 * ネットワークインターフェースのプライベートIPを取得します。
	 *
	 * @return ネットワークインターフェースのプライベートIP
	 */
	public String getPrivateIpAddress() {
		return privateIpAddress;
	}
	/**
	 * ネットワークインターフェースのプライベートIPを設定します。
	 *
	 * @param privateIpAddress ネットワークインターフェースのプライベートIP
	 */
	public void setPrivateIpAddress(String privateIpAddress) {
		this.privateIpAddress = privateIpAddress;
	}
	/**
	 * ネットワークインターフェースのプライベートIPを設定し、自オブジェクトを返します。
	 *
	 * @param privateIpAddress ネットワークインターフェースのプライベートIP
	 * @return 自オブジェクト
	 */
	public PrivateIpAddresses withPrivateIpAddress(String privateIpAddress) {
		setPrivateIpAddress(privateIpAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[association=");
		builder.append(association);
		builder.append(", primary=");
		builder.append(primary);
		builder.append(", privateDnsName=");
		builder.append(privateDnsName);
		builder.append(", privateIpAddress=");
		builder.append(privateIpAddress);
		builder.append("]");
		return builder.toString();
	}
}
