/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyUpdateInstanceNetworkInterfacesリクエストクラス。<br />
 * このクラスはNiftyUpdateInstanceNetworkInterfacesへのリクエストを構築します。
 */

@Action("NiftyUpdateInstanceNetworkInterfaces")
public class NiftyUpdateInstanceNetworkInterfacesRequest implements Request {

	/** サーバー名 */
	private String instanceId;

	/** ネットワークインターフェース情報 */
	private List<NetworkInterface> networkInterfaces;

	/** 再起動オプション */
	private String niftyReboot;

	/**
	 * サーバー名を指定し、NiftyUpdateInstanceNetworkInterfacesRequestを構築します。
	 * @param instanceId サーバー名
	 */
	public NiftyUpdateInstanceNetworkInterfacesRequest(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyUpdateInstanceNetworkInterfacesRequest() {
	}

	/**
	 * サーバー名を取得します。
	 *
	 * @return OSイメージIDサーバー名
	 */
	@Query(name="InstanceId", require=true)
	public String getInstanceId() {
		return instanceId;
	}
	/**
	 * サーバー名を設定します。
	 *
	 * @param instanceId サーバー名
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}
	/**
	 * サーバー名を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId サーバー名
	 * @return 自オブジェクト
	 */
	public NiftyUpdateInstanceNetworkInterfacesRequest withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * ネットワークインターフェース情報を取得します。
	 *
	 * @return ネットワークインターフェース情報
	 */
	@Query(name="NetworkInterface")
	public List<NetworkInterface> getNetworkInterfaces() {
		return networkInterfaces;
	}
	/**
	 * ネットワークインターフェース情報を設定します。
	 *
	 * @param networkInterfaces ネットワークインターフェース情報
	 */
	public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
		this.networkInterfaces = networkInterfaces;
	}
	/**
	 * ネットワークインターフェース情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces
	 * @return 自オブジェクト
	 */
	public NiftyUpdateInstanceNetworkInterfacesRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
		if(this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterface>();
		for (NetworkInterface networkInterface: networkInterfaces) {
			getNetworkInterfaces().add(networkInterface);
		}
		return this;
	}
    /**
     * ネットワークインターフェース情報リストを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaces ネットワークインターフェース情報リスト
     * @return 自オブジェクト
     */
    public NiftyUpdateInstanceNetworkInterfacesRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if(this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterface>();
        if (networkInterfaces!=null) {
            getNetworkInterfaces().addAll(networkInterfaces);
        }
        return this;
    }
	/**
	 * 再起動オプションを取得します。
	 *
	 * @return 再起動オプション
	 */
	@Query(name="NiftyReboot")
	public String getNiftyReboot() {
		return niftyReboot;
	}
	/**
	 * 再起動オプションを設定します。
	 *
	 * @param niftyReboot 再起動オプション
	 */
	public void setNiftyReboot(String niftyReboot) {
		this.niftyReboot = niftyReboot;
	}
	/**
	 * 再起動オプションを設定し、自オブジェクトを返します。
	 *
	 * @param niftyReboot 再起動オプション
	 * @return 自オブジェクト
	 */
	public NiftyUpdateInstanceNetworkInterfacesRequest withNiftyReboot(String niftyReboot) {
		setNiftyReboot(niftyReboot);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceId=");
		builder.append(instanceId);
		builder.append("[networkInterfaces=");
		builder.append(networkInterfaces);
		builder.append("[niftyReboot=");
		builder.append(niftyReboot);
		builder.append("]");
		return builder.toString();
	}
}
