/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Result;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyRetryImportInstance処理結果クラス。<br />
 * このクラスはNiftyRetryImportInstanceのレスポンスを格納します。
 */
@XStreamAlias("NiftyRetryImportInstanceResponse")
public class NiftyRetryImportInstanceResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** 再インポート対象のサーバー名 */
	private String instanceId;

	/** 再インポート対象のサーバーユニークID */
	private String instanceUniqueId;

	/** 再インポート対象のサーバーのステータス */
	private String instanceState;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyRetryImportInstanceResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * 再インポート対象のサーバー名を取得します。
	 *
	 * @return 再インポート対象のサーバー名
	 */
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * 再インポート対象のサーバー名を設定します。
	 *
	 * @param instanceId 再インポート対象のサーバー名
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * 再インポート対象のサーバー名を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId 再インポート対象のサーバー名
	 * @return 自オブジェクト
	 */
	public NiftyRetryImportInstanceResult withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * 再インポート対象のサーバーユニークIDを取得します。
	 *
	 * @return 再インポート対象のサーバーユニークID
	 */
	public String getInstanceUniqueId() {
		return instanceUniqueId;
	}

	/**
	 * 再インポート対象のサーバーユニークIDを設定します。
	 *
	 * @param instanceUniqueId 再インポート対象のサーバーユニークID
	 */
	public void setInstanceUniqueId(String instanceUniqueId) {
		this.instanceUniqueId = instanceUniqueId;
	}

	/**
	 * 再インポート対象のサーバーユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param instanceUniqueId 再インポート対象のサーバーユニークID
	 * @return 自オブジェクト
	 */
	public NiftyRetryImportInstanceResult withInstanceUniqueId(String instanceUniqueId) {
		setInstanceUniqueId(instanceUniqueId);
		return this;
	}

	/**
	 * 再インポート対象のサーバーのステータスを取得します。
	 *
	 * @return 再インポート対象のサーバーのステータス
	 */
	public String getInstanceState() {
		return instanceState;
	}

	/**
	 * 再インポート対象のサーバーのステータスを設定します。
	 *
	 * @param instanceState 再インポート対象のサーバーのステータス
	 */
	public void setInstanceState(String instanceState) {
		this.instanceState = instanceState;
	}

	/**
	 * 再インポート対象のサーバーのステータスを設定し、自オブジェクトを返します。
	 *
	 * @param instanceState 再インポート対象のサーバーのステータス
	 * @return 自オブジェクト
	 */
	public NiftyRetryImportInstanceResult withInstanceState(String instanceState) {
		setInstanceState(instanceState);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", instanceId=");
		builder.append(instanceId);
		builder.append(", instanceUniqueId=");
		builder.append(instanceUniqueId);
		builder.append(", instanceState=");
		builder.append(instanceState);
		builder.append("]");
		return builder.toString();
	}
}
