/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import java.util.List;


/**
 * NetworkInterfaceSetクラス。<br />
 * このクラスはNetworkInterfaceSet情報を格納します。
 */
public class NetworkInterfaceSet {

	private String networkInterfaceId;

	private String subnetId;

	private String vpcId;

	private String description;

	private String ownerId;

	/** ネットワークユニークID */
	private String niftyNetworkId;

	/** ネットワーク名 */
	private String niftyNetworkName;

	/** ネットワークインターフェイスのステータス */
	private String status;

	/** ネットワークインターフェイスのMACアドレス */
	private String macAddress;

	/** プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ) */
	private String privateIpAddress;

	/** プライベートIPアドレス（IPv6） */
	private String privateIpAddressV6;

	private String privateDnsName;

	/** ソース */
	private String sourceDestCheck;

	/** ファイアウォールグループ名リスト */
	private List<String> groupIds;

	/** ネットワークインタフェースの接続情報 */
	private Attachment attachment;

	/** ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報 */
	private Association association;

	private List<PrivateIpAddresses> privateIpAddresses;

	/**
	 * networkInterfaceIdを取得します。
	 *
	 * @return networkInterfaceId
	 */
	public String getNetworkInterfaceId() {
		return networkInterfaceId;
	}
	/**
	 * networkInterfaceIdを設定します。
	 *
	 * @param networkInterfaceId
	 */
	public void setNetworkInterfaceId(String networkInterfaceId) {
		this.networkInterfaceId = networkInterfaceId;
	}
	/**
	 * networkInterfaceIdを設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaceId
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withNetworkInterfaceId(String networkInterfaceId) {
		setNetworkInterfaceId(networkInterfaceId);
		return this;
	}

	/**
	 * subnetIdを取得します。
	 *
	 * @return subnetId
	 */
	public String getSubnetId() {
		return subnetId;
	}
	/**
	 * subnetIdを設定します。
	 *
	 * @param subnetId
	 */
	public void setSubnetId(String subnetId) {
		this.subnetId = subnetId;
	}
	/**
	 * subnetIdを設定し、自オブジェクトを返します。
	 *
	 * @param subnetId
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withSubnetId(String subnetId) {
		setSubnetId(subnetId);
		return this;
	}

	/**
	 * vpcIdを取得します。
	 *
	 * @return vpcId
	 */
	public String getVpcId() {
		return vpcId;
	}
	/**
	 * vpcIdを設定します。
	 *
	 * @param vpcId
	 */
	public void setVpcId(String vpcId) {
		this.vpcId = vpcId;
	}
	/**
	 * vpcIdを設定し、自オブジェクトを返します。
	 *
	 * @param vpcId
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withVpcId(String vpcId) {
		setVpcId(vpcId);
		return this;
	}

	/**
	 * descriptionを取得します。
	 *
	 * @return description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * descriptionを設定します。
	 *
	 * @param description
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * descriptionを設定し、自オブジェクトを返します。
	 *
	 * @param description
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withDescription(String description) {
		setDescription(description);
		return this;
	}

	/**
	 * ownerIdを取得します。
	 *
	 * @return ownerId
	 */
	public String getOwnerId() {
		return ownerId;
	}
	/**
	 * ownerIdを設定します。
	 *
	 * @param ownerId
	 */
	public void setOwnerId(String ownerId) {
		this.ownerId = ownerId;
	}
	/**
	 * ownerIdを設定し、自オブジェクトを返します。
	 *
	 * @param ownerId
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withOwnerId(String ownerId) {
		setOwnerId(ownerId);
		return this;
	}

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	public String getNiftyNetworkId() {
		return niftyNetworkId;
	}
	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param niftyNetworkId ネットワークユニークID
	 */
	public void setNiftyNetworkId(String niftyNetworkId) {
		this.niftyNetworkId = niftyNetworkId;
	}
	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param niftyNetworkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withNiftyNetworkId(String niftyNetworkId) {
		setNiftyNetworkId(niftyNetworkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	public String getNiftyNetworkName() {
		return niftyNetworkName;
	}
	/**
	 * ネットワーク名を設定します。
	 *
	 * @param niftyNetworkName ネットワーク名
	 */
	public void setNiftyNetworkName(String niftyNetworkName) {
		this.niftyNetworkName = niftyNetworkName;
	}
	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyNetworkName ネットワーク名
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withNiftyNetworkName(String niftyNetworkName) {
		setNiftyNetworkName(niftyNetworkName);
		return this;
	}

	/**
	 * ネットワークインターフェイスのステータスを取得します。
	 *
	 * @return status
	 */
	public String getStatus() {
		return status;
	}
	/**
	 * ネットワークインターフェイスのステータスを設定します。
	 *
	 * @param status ネットワークインターフェイスのステータス
	 */
	public void setStatus(String status) {
		this.status = status;
	}
	/**
	 * ネットワークインターフェイスのステータスを設定し、自オブジェクトを返します。
	 *
	 * @param status ネットワークインターフェイスのステータス
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withStatus(String status) {
		setStatus(status);
		return this;
	}

	/**
	 * ネットワークインターフェイスのMACアドレスを取得します。
	 *
	 * @return ネットワークインターフェイスのMACアドレス
	 */
	public String getMacAddress() {
		return macAddress;
	}
	/**
	 * ネットワークインターフェイスのMACアドレスを設定します。
	 *
	 * @param macAddress ネットワークインターフェイスのMACアドレス
	 */
	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}
	/**
	 * ネットワークインターフェイスのMACアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param macAddress ネットワークインターフェイスのMACアドレス
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withMacAddress(String macAddress) {
		setMacAddress(macAddress);
		return this;
	}

	/**
	 * プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ)を取得します。
	 *
	 * @return プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ)
	 */
	public String getPrivateIpAddress() {
		return privateIpAddress;
	}
	/**
	 * プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ)を設定します。
	 *
	 * @param list プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ)
	 */
	public void setPrivateIpAddress(String privateIpAddress) {
		this.privateIpAddress = privateIpAddress;
	}
	/**
	 * プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ)を設定し、自オブジェクトを返します。
	 *
	 * @param privateIpAddress プライベートIPアドレスまたはプライベート付替IPアドレス (グローバルで無いときのみ)
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withPrivateIpAddress(String privateIpAddress) {
		setPrivateIpAddress(privateIpAddress);
		return this;
	}

	/**
	 * プライベートIPアドレス（IPv6）を取得します。
	 *
	 * @return プライベートIPアドレス（IPv6）
	 */
	public String getPrivateIpAddressV6() {
		return privateIpAddressV6;
	}
	/**
	 * プライベートIPアドレス（IPv6）を設定します。
	 *
	 * @param privateIpAddressV6 プライベートIPアドレス（IPv6）
	 */
	public void setPrivateIpAddressV6(String privateIpAddressV6) {
		this.privateIpAddressV6 = privateIpAddressV6;
	}
	/**
	 * プライベートIPアドレス（IPv6）を設定し、自オブジェクトを返します。
	 *
	 * @param privateIpAddressV6 プライベートIPアドレス（IPv6）
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withPrivateIpAddressV6(String privateIpAddressV6) {
		setPrivateIpAddressV6(privateIpAddressV6);
		return this;
	}

	/**
	 * privateDnsNameを取得します。
	 *
	 * @return privateDnsName
	 */
	public String getPrivateDnsName() {
		return privateDnsName;
	}
	/**
	 * privateDnsNameを設定します。
	 *
	 * @param privateDnsName
	 */
	public void setPrivateDnsName(String privateDnsName) {
		this.privateDnsName = privateDnsName;
	}
	/**
	 * privateDnsNameを設定し、自オブジェクトを返します。
	 *
	 * @param privateDnsName
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withPrivateDnsName(String privateDnsName) {
		setPrivateDnsName(privateDnsName);
		return this;
	}

	/**
	 * ソースを取得します。
	 *
	 * @return ソース
	 */
	public String getSourceDestCheck() {
		return sourceDestCheck;
	}
	/**
	 * ソースを設定します。
	 *
	 * @param sourceDestCheck ソース
	 */
	public void setSourceDestCheck(String sourceDestCheck) {
		this.sourceDestCheck = sourceDestCheck;
	}
	/**
	 * ソースを設定し、自オブジェクトを返します。
	 *
	 * @param sourceDestCheck ソース
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withSourceDestCheck(String sourceDestCheck) {
		setSourceDestCheck(sourceDestCheck);
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを取得します。
	 *
	 * @return ファイアウォールグループ名リスト
	 */
	public List<String> getGroupIds() {
		return groupIds;
	}
	/**
	 * ファイアウォールグループ名リストを設定します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}
	/**
	 * ファイアウォールグループ名リストを設定し、自オブジェクトを返します。
	 *
	 * @param sourceDestCheck ファイアウォールグループ名リスト
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withGroupIds(List<String> groupIds) {
		setGroupIds(groupIds);
		return this;
	}

	/**
	 * ネットワークインタフェースの接続情報を取得します。
	 *
	 * @return ネットワークインタフェースの接続情報
	 */
	public Attachment getAttachment() {
		return attachment;
	}
	/**
	 * ネットワークインタフェースの接続情報を設定します。
	 *
	 * @param attachments ネットワークインタフェースの接続情報
	 */
	public void setAttachment(Attachment attachments) {
		this.attachment = attachments;
	}
	/**
	 * ネットワークインタフェースの接続情報を設定し、自オブジェクトを返します。
	 *
	 * @param attachment ネットワークインタフェースの接続情報
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withAttachment(Attachment attachments) {
		setAttachment(attachments);
		return this;
	}

	/**
	 * ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報を取得します。
	 *
	 * @return ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報
	 */
	public Association getAssociation() {
		return association;
	}
	/**
	 * ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報を設定します。
	 *
	 * @param association ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報
	 */
	public void setAssociation(Association associations) {
		this.association = associations;
	}
	/**
	 * ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報を設定し、自オブジェクトを返します。
	 *
	 * @param association ネットワークインタフェースに関連付けられているパブリックIP（固定グローバルIPアドレス、付替IPアドレス）の情報
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withAssociation(Association associations) {
		setAssociation(associations);
		return this;
	}

	/**
	 * privateIpAddressesを取得します。
	 *
	 * @return privateIpAddresses
	 */
	public List<PrivateIpAddresses> getPrivateIpAddresses() {
		return privateIpAddresses;
	}
	/**
	 * privateIpAddressesを設定します。
	 *
	 * @param privateIpAddresses
	 */
	public void setPrivateIpAddresses(List<PrivateIpAddresses> privateIpAddresses) {
		this.privateIpAddresses = privateIpAddresses;
	}
	/**
	 * privateIpAddressesを設定し、自オブジェクトを返します。
	 *
	 * @param privateIpAddresses
	 * @return 自オブジェクト
	 */
	public NetworkInterfaceSet withPrivateIpAddresses(List<PrivateIpAddresses> privateIpAddresses) {
		setPrivateIpAddresses(privateIpAddresses);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkInterfaceId=");
		builder.append(networkInterfaceId);
		builder.append(", subnetId=");
		builder.append(subnetId);
		builder.append(", vpcId=");
		builder.append(vpcId);
		builder.append(", description=");
		builder.append(description);
		builder.append(", ownerId=");
		builder.append(ownerId);
		builder.append(", niftyNetworkId=");
		builder.append(niftyNetworkId);
		builder.append(", niftyNetworkName=");
		builder.append(niftyNetworkName);
		builder.append(", status=");
		builder.append(status);
		builder.append(", macAddress=");
		builder.append(macAddress);
		builder.append(", privateIpAddress=");
		builder.append(privateIpAddress);
		builder.append(", privateIpAddressV6=");
		builder.append(privateIpAddressV6);
		builder.append(", privateDnsName=");
		builder.append(privateDnsName);
		builder.append(", sourceDestCheck=");
		builder.append(sourceDestCheck);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append(", attachment=");
		builder.append(attachment);
		builder.append(", association=");
		builder.append(association);
		builder.append(", privateIpAddresses=");
		builder.append(privateIpAddresses);
		builder.append("]");
		return builder.toString();
	}
}
