/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * NetworkInterfaceクラス。<br />
 * このクラスはNetworkInterface情報を格納します。
 */
public class NetworkInterface {

	private Integer deviceIndex;

	private List<String> securityGroupIds;

	/** ネットワークID */
	private String networkId;

	/** ネットワーク名 */
	private String networkName;

	/** IPアドレス */
	private String ipAddress;


	/**
	 * deviceIndexを取得します。
	 *
	 * @return networkId
	 */
    @Query(name="DeviceIndex")
	public Integer getDeviceIndex() {
		return deviceIndex;
	}
	/**
	 * deviceIndexを設定します。
	 *
	 * @param deviceIndex
	 */
	public void setDeviceIndex(Integer deviceIndex) {
		this.deviceIndex = deviceIndex;
	}
	/**
	 * deviceIndexを設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex
	 * @return 自オブジェクト
	 */
	public NetworkInterface withDeviceIndex(Integer deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * securityGroupIdを取得します。
	 *
	 * @return securityGroupId
	 */
	@Query(name="SecurityGroupId")
	public List<String> getSecurityGroupIds() {
		return securityGroupIds;
	}
	/**
	 * securityGroupIdを設定します。
	 *
	 * @param securityGroupIds
	 */
	public void setSecurityGroupIds(List<String> securityGroupIds) {
		this.securityGroupIds = securityGroupIds;
	}
	/**
	 * securityGroupIdの配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupNames securityGroupIdの配列
	 * @return 自オブジェクト
	 */
	public NetworkInterface withSecurityGroupIds(String ... securityGroupIds) {
		if(this.securityGroupIds == null) this.securityGroupIds = new ArrayList<String>();
		for (String securityGroupId: securityGroupIds) {
			getSecurityGroupIds().add(securityGroupId);
		}
		return this;
	}
	/**
	 * securityGroupIdリストを設定し、自オブジェクトを返します。
	 *
	 * @param groupNames securityGroupIdリスト
	 * @return 自オブジェクト
	 */
	public NetworkInterface withSecurityGroupIds(Collection<String> securityGroupIds) {
		if(this.securityGroupIds == null) this.securityGroupIds = new ArrayList<String>();
		if (securityGroupIds!=null) {
			getSecurityGroupIds().addAll(securityGroupIds);
		}
		return this;
	}

	/**
	 * networkIdを取得します。
	 *
	 * @return networkId
	 */
    @Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}
	/**
	 * networkIdを設定します。
	 *
	 * @param networkId
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}
	/**
	 * networkIdを設定し、自オブジェクトを返します。
	 *
	 * @param networkId
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * networkNameを取得します。
	 *
	 * @return networkName
	 */
    @Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}
	/**
	 * networkNameを設定します。
	 *
	 * @param networkName
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}
	/**
	 * networkNameを設定し、自オブジェクトを返します。
	 *
	 * @param networkName
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * networkIdを取得します。
	 *
	 * @return ipAddress
	 */
    @Query(name="IpAddress")
	public String getIpAddress() {
		return ipAddress;
	}
	/**
	 * ipAddressを設定します。
	 *
	 * @param ipAddress
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}
	/**
	 * ipAddressを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress
	 * @return 自オブジェクト
	 */
	public NetworkInterface withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append("]");
		return builder.toString();
	}
}
