/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ライセンス情報クラス。<br />
 * このクラスはライセンス情報を格納します。
 */
public class License {

    /** ライセンス種別 */
    private String licenseName;

    /** ライセンス数 */
    private String licenseNum;

    /**
     * ライセンス種別を取得します。
     *
     * @return ライセンス種別
     */
    @Query(name = "LicenseName")
    public String getLicenseName() {
        return licenseName;
    }

    /**
     * ライセンス種別を設定します。
     *
     * @param licenseName
     *            ライセンス種別
     */
    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    /**
     * ライセンス種別を設定し、自オブジェクトを返します。
     *
     * @param licenseName
     *            ライセンス種別
     * @return 自オブジェクト
     */
    public License withLicenseName(String licenseName) {
        setLicenseName(licenseName);
        return this;
    }

    /**
     * ライセンス数を取得します。
     *
     * @return ライセンス数
     */
    @Query(name = "LicenseNum")
    public String getLicenseNum() {
        return licenseNum;
    }

    /**
     * ライセンス数を設定します。
     *
     * @param licenseNum
     *            ライセンス数
     */
    public void setLicenseNum(String licenseNum) {
        this.licenseNum = licenseNum;
    }

    /**
     * ライセンス数を設定し、自オブジェクトを返します。
     *
     * @param licenseNum
     *            ライセンス数
     * @return 自オブジェクト
     */
    public License withLicenseNum(String licenseNum) {
        setLicenseNum(licenseNum);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[licenseName=");
        builder.append(licenseName);
        builder.append(", licenseNum=");
        builder.append(licenseNum);
        builder.append("]");
        return builder.toString();
    }
}
