/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

/**
 * 適用しているマルチロードバランサーの情報クラス。<br />
 * このクラスは 適用しているマルチロードバランサーの情報を格納します。
 */
public class InstanceElasticLoadBalancerMapping {

    /** マルチロードバランサーユニークID */
    private String elasticLoadBalancerId;

    /** マルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** マルチロードバランサーのプロトコル */
    private String protocol;

    /** マルチロードバランサーの待ち受けポート */
    private Integer elasticLoadBalancerPort;

    /** マルチロードバランサーの宛先ポート */
    private Integer instancePort;

    /**
     * マルチロードバランサーユニークIDを取得します。
     *
     * @return マルチロードバランサーユニークID
     */
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定します。
     *
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public InstanceElasticLoadBalancerMapping
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * マルチロードバランサー名を取得します。
     *
     * @return マルチロードバランサー名
     */
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     *
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public InstanceElasticLoadBalancerMapping
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * マルチロードバランサーのプロトコルを取得します。
     *
     * @return マルチロードバランサーのプロトコル
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * マルチロードバランサーのプロトコルを設定します。
     *
     * @param protocol
     *            マルチロードバランサーのプロトコル
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * マルチロードバランサーのプロトコルを設定し、自オブジェクトを返します。
     *
     * @param protocol
     *            マルチロードバランサーのプロトコル
     * @return 自オブジェクト
     */
    public InstanceElasticLoadBalancerMapping withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * マルチロードバランサーの待ち受けポートを取得します。
     *
     * @return マルチロードバランサーの待ち受けポート
     */
    public Integer getElasticLoadBalancerPort() {
        return elasticLoadBalancerPort;
    }

    /**
     * マルチロードバランサーの待ち受けポートを設定します。
     *
     * @param elasticLoadBalancerPort
     *            マルチロードバランサーの待ち受けポート
     */
    public void setElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        this.elasticLoadBalancerPort = elasticLoadBalancerPort;
    }

    /**
     * マルチロードバランサーの待ち受けポートを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerPort
     *            マルチロードバランサーの待ち受けポート
     * @return 自オブジェクト
     */
    public InstanceElasticLoadBalancerMapping
        withElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        setElasticLoadBalancerPort(elasticLoadBalancerPort);
        return this;
    }

    /**
     * マルチロードバランサーの宛先ポートを取得します。
     *
     * @return マルチロードバランサーの宛先ポート
     */
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * マルチロードバランサーの宛先ポートを設定します。
     *
     * @param instancePort
     *            マルチロードバランサーの宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * マルチロードバランサーの宛先ポートを設定し、自オブジェクトを返します。
     *
     * @param instancePort
     *            マルチロードバランサーの宛先ポート
     * @return 自オブジェクト
     */
    public InstanceElasticLoadBalancerMapping withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);
        builder.append(", elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);
        builder.append(", protocol=");
        builder.append(protocol);
        builder.append(", elasticLoadBalancerPort=");
        builder.append(elasticLoadBalancerPort);
        builder.append(", instancePort=");
        builder.append(instancePort);
        builder.append("]");
        return builder.toString();
    }
}
