/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DescribeInstancesリクエストクラス。<br />
 * このクラスはDescribeInstancesへのリクエストを構築します。
 *
 */
@Action("DescribeInstances")
public class DescribeInstancesRequest implements Request {

	/** サーバー名リスト */
	List<String> 	instanceIds;

	/** テナント属性リスト */
	List<String> 	tenancys;

	/**
	 * サーバー名リストを取得します。
	 *
	 * @return サーバー名リスト
	 */
	@Query(name="InstanceId")
	public List<String> getInstanceIds() {
		return instanceIds;
	}
	/**
	 * サーバー名リストを設定します。
	 *
	 * @param instanceIds サーバー名リスト
	 */
	public void setInstanceIds(List<String> instanceIds) {
		this.instanceIds = instanceIds;
	}
	/**
	 * サーバー名の配列を設定し、自オブジェクトを返します。
	 *
	 * @param instanceIds サーバー名の配列
	 * @return 自オブジェクト
	 */
	public DescribeInstancesRequest withInstanceIds(String ... instanceIds) {
		if(this.instanceIds == null) this.instanceIds = new ArrayList<String>();
		for(String instanceId : instanceIds) {
			getInstanceIds().add(instanceId);
		}
		return this;
	}
	/**
	 * サーバー名リストを設定し、自オブジェクトを返します。
	 *
	 * @param instanceIds サーバー名リスト
	 * @return 自オブジェクト
	 */
	public DescribeInstancesRequest withInstanceIds(Collection<String> instanceIds) {
		if(this.instanceIds == null) this.instanceIds = new ArrayList<String>();
		if(instanceIds != null){
			getInstanceIds().addAll(instanceIds);
		}
		return this;
	}

	/**
	 * テナント属性リストを取得します。
	 *
	 * @return テナント属性リスト
	 */
	@Query(name="Tenancy")
	public List<String> getTenancys() {
		return tenancys;
	}
	/**
	 * テナント属性リストを設定します。
	 *
	 * @param tenancys テナント属性リスト
	 */
	public void setTenancys(List<String> tenancys) {
		this.tenancys = tenancys;
	}
	/**
	 * テナント属性の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tenancys テナント属性の配列
	 * @return 自オブジェクト
	 */
	public DescribeInstancesRequest withTenancys(String ... tenancys) {
		if(this.tenancys == null) this.tenancys = new ArrayList<String>();
		for(String tenancy : tenancys) {
			getTenancys().add(tenancy);
		}
		return this;
	}
	/**
	 * テナント属性リストを設定し、自オブジェクトを返します。
	 *
	 * @param tenancys テナント属性リスト
	 * @return 自オブジェクト
	 */
	public DescribeInstancesRequest withTenancys(Collection<String> tenancys) {
		if(this.tenancys == null) this.tenancys = new ArrayList<String>();
		if(tenancys != null){
			getTenancys().addAll(tenancys);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceIds=");
		builder.append(instanceIds);
		builder.append(", tenancys=");
		builder.append(tenancys);
		builder.append("]");
		return builder.toString();
	}

}
