/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;

import java.util.Date;

/**
 * Attachmentクラス。<br />
 * このクラスはAttachment情報を格納します。
 */
public class Attachment {

	private String attachmentId;

	/** デバイス番号 */
	private Short deviceIndex;

	/** 接続状態 */
	private String status;

	private Date attachTime;

	/** サーバー削除時のネットワークインターフェース消去 */
	private Boolean deleteOnTermination;


	/**
	 * attachmentIdを取得します。
	 *
	 * @return attachmentId
	 */
	public String getAttachmentId() {
		return attachmentId;
	}
	/**
	 * attachmentIdを設定します。
	 *
	 * @param attachmentId
	 */
	public void setAttachmentId(String attachmentId) {
		this.attachmentId = attachmentId;
	}
	/**
	 * attachmentIdを設定し、自オブジェクトを返します。
	 *
	 * @param attachmentId
	 * @return 自オブジェクト
	 */
	public Attachment withAttachmentId(String attachmentId) {
		setAttachmentId(attachmentId);
		return this;
	}

	/**
	 * デバイス番号を取得します。
	 *
	 * @return デバイス番号
	 */
	public Short getDeviceIndex() {
		return deviceIndex;
	}
	/**
	 * デバイス番号を設定します。
	 *
	 * @param deviceIndex デバイス番号
	 */
	public void setDeviceIndex(Short deviceIndex) {
		this.deviceIndex = deviceIndex;
	}
	/**
	 * デバイス番号を設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex デバイス番号
	 * @return 自オブジェクト
	 */
	public Attachment withDeviceIndex(Short deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * 接続状態を取得します。
	 *
	 * @return 接続状態
	 */
	public String getStatus() {
		return status;
	}
	/**
	 * 接続状態を設定します。
	 *
	 * @param status 接続状態
	 */
	public void setStatus(String status) {
		this.status = status;
	}
	/**
	 * 接続状態を設定し、自オブジェクトを返します。
	 *
	 * @param status 接続状態
	 * @return 自オブジェクト
	 */
	public Attachment withStatus(String status) {
		setStatus(status);
		return this;
	}

	/**
	 * attachTimeを取得します。
	 *
	 * @return attachTime
	 */
	public Date getAttachTime() {
		return attachTime;
	}
	/**
	 * attachTimeを設定します。
	 *
	 * @param attachTime
	 */
	public void setAttachTime(Date attachTime) {
		this.attachTime = attachTime;
	}
	/**
	 * attachTimeを設定し、自オブジェクトを返します。
	 *
	 * @param attachTime
	 * @return 自オブジェクト
	 */
	public Attachment withAttachTime(Date attachTime) {
		setAttachTime(attachTime);
		return this;
	}

	/**
	 * サーバー削除時のネットワークインターフェース消去を取得します。
	 *
	 * @return サーバー削除時のネットワークインターフェース消去
	 */
	public Boolean getDeleteOnTermination() {
		return deleteOnTermination;
	}
	/**
	 * サーバー削除時のネットワークインターフェース消去を設定します。
	 *
	 * @param deleteOnTermination サーバー削除時のネットワークインターフェース消去
	 */
	public void setDeleteOnTermination(Boolean deleteOnTermination) {
		this.deleteOnTermination = deleteOnTermination;
	}
	/**
	 * サーバー削除時のネットワークインターフェース消去を設定し、自オブジェクトを返します。
	 *
	 * @param deleteOnTermination サーバー削除時のネットワークインターフェース消去
	 * @return 自オブジェクト
	 */
	public Attachment withDeleteOnTermination(Boolean deleteOnTermination) {
		setDeleteOnTermination(deleteOnTermination);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[attachmentId=");
		builder.append(attachmentId);
		builder.append(", deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", status=");
		builder.append(status);
		builder.append(", attachTime=");
		builder.append(attachTime);
		builder.append(", deleteOnTermination=");
		builder.append(deleteOnTermination);
		builder.append("]");
		return builder.toString();
	}
}
