/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.server.model;


/**
 * Associationクラス。<br />
 * このクラスはAssociation情報を格納します。
 */
public class Association {

	/** グローバルIPアドレスまたはグローバル付替IPアドレス */
	private String publicIp;

	/** グローバルIPアドレス(IPv6) */
	private String publicIpV6;

	private String publicDnsName;

	private String ipOwnerId;


	/**
	 * グローバルIPアドレスまたはグローバル付替IPアドレスを取得します。
	 *
	 * @return グローバルIPアドレスまたはグローバル付替IPアドレス
	 */
	public String getPublicIp() {
		return publicIp;
	}
	/**
	 * グローバルIPアドレスまたはグローバル付替IPアドレスを設定します。
	 *
	 * @param publicIp グローバルIPアドレスまたはグローバル付替IPアドレス
	 */
	public void setPublicIp(String publicIp) {
		this.publicIp = publicIp;
	}
	/**
	 * グローバルIPアドレスまたはグローバル付替IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param publicIp グローバルIPアドレスまたはグローバル付替IPアドレス
	 * @return 自オブジェクト
	 */
	public Association withPublicIp(String publicIp) {
		setPublicIp(publicIp);
		return this;
	}

	/**
	 * グローバルIPアドレス(IPv6)を取得します。
	 *
	 * @return グローバルIPアドレス(IPv6)
	 */
	public String getPublicIpV6() {
		return publicIpV6;
	}
	/**
	 * グローバルIPアドレス(IPv6)を設定します。
	 *
	 * @param publicIpV6 グローバルIPアドレス(IPv6)
	 */
	public void setPublicIpV6(String publicIpV6) {
		this.publicIpV6 = publicIpV6;
	}
	/**
	 * グローバルIPアドレス(IPv6)を設定し、自オブジェクトを返します。
	 *
	 * @param publicIpV6 グローバルIPアドレス(IPv6)
	 * @return 自オブジェクト
	 */
	public Association withPublicIpV6(String publicIpV6) {
		setPublicIpV6(publicIpV6);
		return this;
	}

	/**
	 * publicDnsNameを取得します。
	 *
	 * @return publicDnsName
	 */
	public String getPublicDnsName() {
		return publicDnsName;
	}
	/**
	 * publicDnsNameを設定します。
	 *
	 * @param publicDnsName
	 */
	public void setPublicDnsName(String publicDnsName) {
		this.publicDnsName = publicDnsName;
	}
	/**
	 * publicDnsNameを設定し、自オブジェクトを返します。
	 *
	 * @param publicDnsName
	 * @return 自オブジェクト
	 */
	public Association withPublicDnsName(String publicDnsName) {
		setPublicDnsName(publicDnsName);
		return this;
	}

	/**
	 * ipOwnerIdを取得します。
	 *
	 * @return ipOwnerId
	 */
	public String getIpOwnerId() {
		return ipOwnerId;
	}
	/**
	 * ipOwnerIdを設定します。
	 *
	 * @param ipOwnerId
	 */
	public void setIpOwnerId(String ipOwnerId) {
		this.ipOwnerId = ipOwnerId;
	}
	/**
	 * ipOwnerIdを設定し、自オブジェクトを返します。
	 *
	 * @param ipOwnerId
	 * @return 自オブジェクト
	 */
	public Association withIpOwnerId(String ipOwnerId) {
		setIpOwnerId(ipOwnerId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[publicIp=");
		builder.append(publicIp);
		builder.append(", publicIpV6=");
		builder.append(publicIpV6);
		builder.append(", publicDnsName=");
		builder.append(publicDnsName);
		builder.append(", ipOwnerId=");
		builder.append(ipOwnerId);
		builder.append("]");
		return builder.toString();
	}
}
