/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.separate.model.Instance;
import com.nifty.cloud.sdk.separate.model.SeparateInstanceRulesInfo;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * separateInstanceRulesInfo変換クラス。<br />
 * このクラスはレスポンスXMLのseparateInstanceRulesInfo要素からSeparateInstanceRulesInfoクラスのリストを生成します。
 *
 */
public class SeparateInstanceRulesInfoConverter implements Converter {

    private static final String ELEMENT_SEPARATE_INSTANCE_RULE_NAME = "separateInstanceRuleName";
    private static final String ELEMENT_SEPARATE_INSTANCE_RULE_DESCRIPTION = "separateInstanceRuleDescription";
    private static final String ELEMENT_SEPARATE_INSTANCE_RULE_STATUS = "separateInstanceRuleStatus";
    private static final String ELEMENT_SEPARATE_INSTANCE = "instancesSet";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * separateInstanceRulesInfoをList<SeparateInstanceRulesInfo>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<SeparateInstanceRulesInfo>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<SeparateInstanceRulesInfo> separateInstanceRulesInfos = new ArrayList<SeparateInstanceRulesInfo>();
        SeparateInstanceRulesInfo separateInstanceRulesInfo;
        Converter instancesConverter = new InstancesConverter();

        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            separateInstanceRulesInfo = new SeparateInstanceRulesInfo();

            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_SEPARATE_INSTANCE_RULE_NAME)) {
                    separateInstanceRulesInfo.setSeparateInstanceRuleName(reader.getValue());
                } else if (name.equals(ELEMENT_SEPARATE_INSTANCE_RULE_DESCRIPTION)) {
                    separateInstanceRulesInfo.setSeparateInstanceRuleDescription(reader.getValue());
                } else if (name.equals(ELEMENT_SEPARATE_INSTANCE_RULE_STATUS)) {
                    separateInstanceRulesInfo.setSeparateInstanceRuleStatus(reader.getValue());
                } else if (name.equals(ELEMENT_SEPARATE_INSTANCE)) {
                    separateInstanceRulesInfo.setInstances((List<Instance>) instancesConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    separateInstanceRulesInfo.setAvailabilityZone(reader.getValue());
                }
                reader.moveUp();
            }
            reader.moveUp();
            separateInstanceRulesInfos.add(separateInstanceRulesInfo);
        }

        return separateInstanceRulesInfos;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {
        // 処理無し
    }

}
