/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.separate.model.transform.InstancesConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * サーバーセパレート情報。<br />
 * このクラスはサーバーセパレート情報を格納します。
 */
public class SeparateInstanceRulesInfo {

    /** サーバーセパレート名 */
    @XStreamAlias("separateInstanceRuleName")
    private String separateInstanceRuleName;

    /** サーバーセパレートのメモ */
    @XStreamAlias("separateInstanceRuleDescription")
    private String separateInstanceRuleDescription;

    /** サーバーセパレートの現在のステータス */
    @XStreamAlias("separateInstanceRuleStatus")
    private String separateInstanceRuleStatus;

    /** 適用しているサーバー情報リスト */
    @XStreamAlias("instancesSet")
    @XStreamConverter(InstancesConverter.class)
    private List<Instance> instances;

    /** ゾーン情報 */
    @XStreamAlias("availabilityZone")
    private String availabilityZone;

    /**
     * サーバーセパレート名を取得します。
     *
     * @return サーバーセパレート名
     */
    public String getSeparateInstanceRuleName() {
        return separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     */
    public void setSeparateInstanceRuleName(String separateInstanceRuleName) {
        this.separateInstanceRuleName = separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     * @return 自オブジェクト
     */
    public SeparateInstanceRulesInfo
        withSeparateInstanceRuleName(String separateInstanceRuleName) {
        setSeparateInstanceRuleName(separateInstanceRuleName);
        return this;
    }

    /**
     * サーバーセパレートのメモを取得します。
     *
     * @return サーバーセパレートのメモ
     */
    public String getSeparateInstanceRuleDescription() {
        return separateInstanceRuleDescription;
    }

    /**
     * サーバーセパレートのメモを設定します。
     *
     * @param separateInstanceRuleDescription
     *            サーバーセパレートのメモ
     */
    public void setSeparateInstanceRuleDescription(String separateInstanceRuleDescription) {
        this.separateInstanceRuleDescription = separateInstanceRuleDescription;
    }

    /**
     * サーバーセパレートのメモを設定し、自オブジェクトを返します。
     * 
     * @param separateInstanceRuleDescription
     *            サーバーセパレートのメモ
     * @return 自オブジェクト
     */
    public SeparateInstanceRulesInfo
        withSeparateInstanceRuleDescription(String separateInstanceRuleDescription) {
        setSeparateInstanceRuleDescription(separateInstanceRuleDescription);
        return this;
    }

    /**
     * サーバーセパレートの現在のステータスを取得します。
     *
     * @return サーバーセパレートの現在のステータス
     */
    public String getSeparateInstanceRuleStatus() {
        return separateInstanceRuleStatus;
    }

    /**
     * サーバーセパレートの現在のステータスを設定します。
     *
     * @param separateInstanceRuleStatus
     *            サーバーセパレートの現在のステータス
     */
    public void setSeparateInstanceRuleStatus(String separateInstanceRuleStatus) {
        this.separateInstanceRuleStatus = separateInstanceRuleStatus;
    }

    /**
     * サーバーセパレートの現在のステータスを設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleStatus
     *            サーバーセパレートの現在のステータス
     * @return 自オブジェクト
     */
    public SeparateInstanceRulesInfo
        withSeparateInstanceRuleStatus(String separateInstanceRuleStatus) {
        setSeparateInstanceRuleStatus(separateInstanceRuleStatus);
        return this;
    }

    /**
     * サーバー情報リストを取得します。
     * 
     * @return サーバー情報リスト
     */
    public List<Instance> getInstances() {
        return instances;
    }

    /**
     * サーバー情報リストを設定します。
     * 
     * @param instances
     *            サーバー情報リスト
     */
    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    /**
     * サーバー情報の配列を設定し、自オブジェクトを返します。
     *
     * @param instances
     *            サーバー情報の配列
     * @return 自オブジェクト
     */
    public SeparateInstanceRulesInfo
        withInstances(Instance... instances) {
        if (this.instances == null)
            this.instances = new ArrayList<Instance>();
        for (Instance instance : instances) {
            getInstances().add(instance);
        }
        return this;
    }

    /**
     * サーバー情報リストを設定し、自オブジェクトを返します。
     *
     * @param instances
     *            サーバー情報リスト
     * @return 自オブジェクト
     */
    public SeparateInstanceRulesInfo
        withInstances(Collection<Instance> instances) {
        if (this.instances == null)
            this.instances = new ArrayList<Instance>();
        if (instances != null) {
            getInstances().addAll(instances);
        }
        return this;
    }

    /**
     * ゾーン名を取得します。
     *
     * @return ゾーン名
     */
    public String getAvailabilityZone() {
        return availabilityZone;
    }

    /**
     * ゾーン名を設定します。
     *
     * @param availabilityZone
     *            ゾーン名
     */
    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * ゾーン名を設定し、自オブジェクトを返します。
     *
     * @param availabilityZone
     *            ゾーン名
     * @return 自オブジェクト
     */
    public SeparateInstanceRulesInfo withAvailabilityZone(String availabilityZone) {
        setAvailabilityZone(availabilityZone);
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[separateInstanceRuleName=");
        builder.append(separateInstanceRuleName);
        builder.append(", separateInstanceRuleDescription=");
        builder.append(separateInstanceRuleDescription);
        builder.append(", separateInstanceRuleStatus=");
        builder.append(separateInstanceRuleStatus);
        builder.append(", instances=");
        builder.append(instances);
        builder.append(", availabilityZone=");
        builder.append(availabilityZone);
        builder.append("]");
        return builder.toString();
    }

}
