/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyUpdateSeparateInstanceRuleリクエストクラス。<br />
 * このクラスはNiftyUpdateSeparateInstanceRuleへのリクエストを構築します。
 *
 */
@Action("NiftyUpdateSeparateInstanceRule")
public class NiftyUpdateSeparateInstanceRuleRequest implements Request {

    /** サーバーセパレート名 */
    private String separateInstanceRuleName;

    /** 更新後のサーバーセパレート名 */
    private String separateInstanceRuleNameUpdate;

    /** 更新後のサーバーセパレートのメモ */
    private String separateInstanceRuleDescriptionUpdate;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyUpdateSeparateInstanceRuleRequest() {
    }

    /**
     * サーバーセパレート名を取得します。
     *
     * @return サーバーセパレート名
     */
    @Query(name = "SeparateInstanceRuleName", require = true)
    public String getSeparateInstanceRuleName() {
        return separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     */
    public void setSeparateInstanceRuleName(String separateInstanceRuleName) {
        this.separateInstanceRuleName = separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     * @return 自オブジェクト
     */
    public NiftyUpdateSeparateInstanceRuleRequest
        withSeparateInstanceRuleName(String separateInstanceRuleName) {
        setSeparateInstanceRuleName(separateInstanceRuleName);
        return this;
    }

    /**
     * 更新後のサーバーセパレート名を取得します。
     *
     * @return 更新後のサーバーセパレート名
     */
    @Query(name = "SeparateInstanceRuleNameUpdate")
    public String getSeparateInstanceRuleNameUpdate() {
        return separateInstanceRuleNameUpdate;
    }

    /**
     * 更新後のサーバーセパレート名を設定します。
     *
     * @param separateInstanceRuleNameUpdate
     *            更新後のサーバーセパレート名
     */
    public void setSeparateInstanceRuleNameUpdate(String separateInstanceRuleNameUpdate) {
        this.separateInstanceRuleNameUpdate = separateInstanceRuleNameUpdate;
    }

    /**
     * 更新後のサーバーセパレート名を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleNameUpdate
     *            更新後のサーバーセパレート名
     * @return 自オブジェクト
     */
    public NiftyUpdateSeparateInstanceRuleRequest
        withSeparateInstanceRuleNameUpdate(String separateInstanceRuleNameUpdate) {
        setSeparateInstanceRuleNameUpdate(separateInstanceRuleNameUpdate);
        return this;
    }

    /**
     * 更新後のサーバーセパレートのメモを取得します。
     *
     * @return 更新後のサーバーセパレートのメモ
     */
    @Query(name = "SeparateInstanceRuleDescriptionUpdate")
    public String getSeparateInstanceRuleDescriptionUpdate() {
        return separateInstanceRuleDescriptionUpdate;
    }

    /**
     * 更新後のサーバーセパレートのメモを設定します。
     *
     * @param separateInstanceRuleDescriptionUpdate
     *            更新後のサーバーセパレートのメモ
     */
    public void
        setSeparateInstanceRuleDescriptionUpdate(String separateInstanceRuleDescriptionUpdate) {
        this.separateInstanceRuleDescriptionUpdate = separateInstanceRuleDescriptionUpdate;
    }

    /**
     * 更新後のサーバーセパレートのメモを設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleDescriptionUpdate
     *            更新後のサーバーセパレートのメモ
     * @return 自オブジェクト
     */
    public NiftyUpdateSeparateInstanceRuleRequest
        withSeparateInstanceRuleDescriptionUpdate(String separateInstanceRuleDescriptionUpdate) {
        setSeparateInstanceRuleDescriptionUpdate(separateInstanceRuleDescriptionUpdate);
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[separateInstanceRuleName=");
        builder.append(separateInstanceRuleName);
        builder.append(", separateInstanceRuleNameUpdate=");
        builder.append(separateInstanceRuleNameUpdate);
        builder.append(", separateInstanceRuleDescriptionUpdate=");
        builder.append(separateInstanceRuleDescriptionUpdate);
        builder.append("]");
        return builder.toString();
    }

}
