/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyRegisterInstancesWithSeparateInstanceRuleリクエストクラス。<br />
 * このクラスはNiftyRegisterInstancesWithSeparateInstanceRuleへのリクエストを構築します。
 *
 */
@Action("NiftyRegisterInstancesWithSeparateInstanceRule")
public class NiftyRegisterInstancesWithSeparateInstanceRuleRequest implements Request {

    /** サーバーセパレート名 */
    private String separateInstanceRuleName;

    /** サーバー名リスト */
    private List<String> instanceIds;

    /** サーバーユニークIDリスト */
    private List<String> instanceUniqueIds;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleRequest() {
    }

    /**
     * サーバーセパレート名を取得します。
     *
     * @return サーバーセパレート名
     */
    @Query(name = "SeparateInstanceRuleName", require = true)
    public String getSeparateInstanceRuleName() {
        return separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     */
    public void setSeparateInstanceRuleName(String separateInstanceRuleName) {
        this.separateInstanceRuleName = separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     * @return 自オブジェクト
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleRequest
        withSeparateInstanceRuleName(String separateInstanceRuleName) {
        setSeparateInstanceRuleName(separateInstanceRuleName);
        return this;
    }

    /**
     * サーバー名リストを取得します。
     *
     * @return サーバー名リスト
     */
    @Query(name = "InstanceId")
    public List<String> getInstanceIds() {
        return instanceIds;
    }

    /**
     * サーバー名リストを設定します。
     *
     * @param instanceIds
     *            サーバー名リスト
     */
    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    /**
     * サーバー名リストを設定し、自オブジェクトを返します。
     *
     * @param instanceIds
     *            サーバー名リスト
     * @return 自オブジェクト
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleRequest
        withInstanceIds(Collection<String> instanceIds) {
        if (this.instanceIds == null)
            this.instanceIds = new ArrayList<String>();
        if (instanceIds != null) {
            this.instanceIds.addAll(instanceIds);
        }
        return this;
    }

    /**
     * サーバー名の配列を設定し、自オブジェクトを返します。
     *
     * @param instanceIds
     *            サーバー名の配列
     * @return 自オブジェクト
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleRequest
        withInstanceIds(String... instanceIds) {
        if (this.instanceIds == null)
            this.instanceIds = new ArrayList<String>();
        for (String item : instanceIds) {
            this.instanceIds.add(item);
        }
        return this;
    }

    /**
     * サーバーユニークIDリストを取得します。
     *
     * @return サーバーユニークIDリスト
     */
    @Query(name = "InstanceUniqueId")
    public List<String> getInstanceUniqueIds() {
        return instanceUniqueIds;
    }

    /**
     * サーバーユニークIDリストを設定します。
     *
     * @param instanceUniqueIds
     *            サーバーユニークIDリスト
     */
    public void setInstanceUniqueIds(List<String> instanceUniqueIds) {
        this.instanceUniqueIds = instanceUniqueIds;
    }

    /**
     * サーバーユニークIDリストを設定し、自オブジェクトを返します。
     *
     * @param instanceUniqueIds
     *            サーバーユニークIDリスト
     * @return 自オブジェクト
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleRequest
        withInstanceUniqueIds(Collection<String> instanceUniqueIds) {
        if (this.instanceUniqueIds == null)
            this.instanceUniqueIds = new ArrayList<String>();
        if (instanceUniqueIds != null) {
            this.instanceUniqueIds.addAll(instanceUniqueIds);
        }
        return this;
    }

    /**
     * サーバーユニークIDの配列を設定し、自オブジェクトを返します。
     *
     * @param instanceUniqueIds
     *            サーバーユニークIDの配列
     * @return 自オブジェクト
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleRequest
        withInstanceUniqueIds(String... instanceUniqueIds) {
        if (this.instanceUniqueIds == null)
            this.instanceUniqueIds = new ArrayList<String>();
        for (String item : instanceUniqueIds) {
            this.instanceUniqueIds.add(item);
        }
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[separateInstanceRuleName=");
        builder.append(separateInstanceRuleName);
        builder.append(", instanceIds=");
        builder.append(instanceIds);
        builder.append(", instanceUniqueIds=");
        builder.append(instanceUniqueIds);
        builder.append("]");
        return builder.toString();
    }

}
