/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.separate.model.transform.SeparateInstanceRulesInfoConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeSeparateInstanceRules結果処理クラス。<br />
 * このクラスはNiftyDescribeSeparateInstanceRulesのレスポンスを格納します。
 *
 */
@XStreamAlias("NiftyDescribeSeparateInstanceRulesResponse")
public class NiftyDescribeSeparateInstanceRulesResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** サーバーセパレート情報セット */
    @XStreamAlias("separateInstanceRulesInfo")
    @XStreamConverter(SeparateInstanceRulesInfoConverter.class)
    private List<SeparateInstanceRulesInfo> separateInstanceRulesInfos;

    /**
     * リクエスト識別子を取得します。
     *
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     *
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     *
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * サーバーセパレート情報リストを取得します。
     * 
     * @return サーバーセパレート情報リスト
     */
    public List<SeparateInstanceRulesInfo> getSeparateInstanceRulesInfos() {
        return separateInstanceRulesInfos;
    }

    /**
     * サーバーセパレート情報リストを設定します。
     * 
     * @param separateInstanceRulesInfos
     *            サーバーセパレート情報リスト
     */
    public void
        setSeparateInstanceRulesInfos(List<SeparateInstanceRulesInfo> separateInstanceRulesInfos) {
        this.separateInstanceRulesInfos = separateInstanceRulesInfos;
    }

    /**
     * サーバーセパレート情報の配列を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRulesInfos
     *            サーバーセパレート情報の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesResult
        withSeparateInstanceRulesInfos(SeparateInstanceRulesInfo... separateInstanceRulesInfos) {
        if (this.separateInstanceRulesInfos == null)
            this.separateInstanceRulesInfos = new ArrayList<SeparateInstanceRulesInfo>();
        for (SeparateInstanceRulesInfo instance : separateInstanceRulesInfos) {
            getSeparateInstanceRulesInfos().add(instance);
        }
        return this;
    }

    /**
     * サーバーセパレート情報リストを設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRulesInfos
     *            サーバーセパレート情報リスト
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesResult
        withSeparateInstanceRulesInfos(
            Collection<SeparateInstanceRulesInfo> separateInstanceRulesInfos) {
        if (this.separateInstanceRulesInfos == null)
            this.separateInstanceRulesInfos = new ArrayList<SeparateInstanceRulesInfo>();
        if (separateInstanceRulesInfos != null) {
            getSeparateInstanceRulesInfos().addAll(separateInstanceRulesInfos);
        }
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(", separateInstanceRulesInfos=");
        builder.append(separateInstanceRulesInfos);
        builder.append("]");
        return builder.toString();
    }

}
