/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeSeparateInstanceRulesリクエストクラス。<br />
 * このクラスはNiftyDescribeSeparateInstanceRulesへのリクエストを構築します。
 *
 */
@Action("NiftyDescribeSeparateInstanceRules")
public class NiftyDescribeSeparateInstanceRulesRequest implements Request {

    /** サーバーセパレート名リスト */
    private List<String> separateInstanceRuleNames;

    /** 絞り込み情報リスト */
    private List<Filter> filters;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyDescribeSeparateInstanceRulesRequest() {
    }

    /**
     * サーバーセパレート名リストを取得します。
     *
     * @return サーバーセパレート名リスト
     */
    @Query(name = "SeparateInstanceRuleName")
    public List<String> getSeparateInstanceRuleNames() {
        return separateInstanceRuleNames;
    }

    /**
     * サーバーセパレート名リストを設定します。
     *
     * @param separateInstanceRuleNames
     *            サーバーセパレート名リスト
     */
    public void setSeparateInstanceRuleNames(List<String> separateInstanceRuleNames) {
        this.separateInstanceRuleNames = separateInstanceRuleNames;
    }

    /**
     * サーバーセパレート名の配列を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleNames
     *            サーバーセパレート名の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesRequest
        withSeparateInstanceRuleNames(String... separateInstanceRuleNames) {
        if (this.separateInstanceRuleNames == null)
            this.separateInstanceRuleNames = new ArrayList<String>();
        for (String separateInstanceRuleName : separateInstanceRuleNames) {
            getSeparateInstanceRuleNames().add(separateInstanceRuleName);
        }
        return this;
    }

    /**
     * サーバーセパレート名リストを設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleName サーバーセパレート名リスト
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesRequest
        withSeparateInstanceRuleNames(Collection<String> separateInstanceRuleNames) {
        if (this.separateInstanceRuleNames == null)
            this.separateInstanceRuleNames = new ArrayList<String>();
        if (separateInstanceRuleNames != null) {
            getSeparateInstanceRuleNames().addAll(separateInstanceRuleNames);
        }
        return this;
    }

    /**
     * 絞り込み情報リストを取得します。
     *
     * @return 絞り込み情報リスト
     */
    @Query(name = "Filter")
    public List<Filter> getFilters() {
        return filters;
    }

    /**
     * 絞り込み情報リストを設定します。
     *
     * @param filters
     *            絞り込み情報リスト
     */
    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    /**
     * 絞り込み情報の配列を設定し、自オブジェクトを返します。
     *
     * @param filters
     *            絞り込み情報の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesRequest withFilters(Filter... filters) {
        if (this.filters == null)
            this.filters = new ArrayList<Filter>();
        for (Filter filter : filters) {
            getFilters().add(filter);
        }
        return this;
    }

    /**
     * 絞り込み情報リストを設定し、自オブジェクトを返します。
     *
     * @param filters
     *            絞り込み情報リスト
     * @return 自オブジェクト
     */
    public NiftyDescribeSeparateInstanceRulesRequest withFilters(Collection<Filter> filters) {
        if (this.filters == null)
            this.filters = new ArrayList<Filter>();
        if (filters != null) {
            getFilters().addAll(filters);
        }
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[separateInstanceRuleName=");
        builder.append(separateInstanceRuleNames);
        builder.append(", filters=");
        builder.append(filters);
        builder.append("]");
        return builder.toString();
    }

}
