/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.separate.model.transform.InstancesConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDeregisterInstancesFromSeparateInstanceRule結果処理クラス。<br />
 * このクラスはNiftyDeregisterInstancesFromSeparateInstanceRuleのレスポンスを格納します。
 *
 */
@XStreamAlias("NiftyDeregisterInstancesFromSeparateInstanceRuleResponse")
public class NiftyDeregisterInstancesFromSeparateInstanceRuleResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** 解除に成功したサーバー情報リスト */
    @XStreamAlias("instancesSet")
    @XStreamConverter(InstancesConverter.class)
    private List<Instance> instances;

    /**
     * リクエスト識別子を取得します。
     *
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     *
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     *
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyDeregisterInstancesFromSeparateInstanceRuleResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * 解除に成功したサーバー情報リストを取得します。
     * 
     * @return 解除に成功したサーバー情報リスト
     */
    public List<Instance> getInstances() {
        return instances;
    }

    /**
     * 解除に成功したサーバー情報リストを設定します。
     * 
     * @param instances
     *            解除に成功したサーバー情報リスト
     */
    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    /**
     * 解除に成功したサーバー情報の配列を設定し、自オブジェクトを返します。
     *
     * @param instances
     *            解除に成功したサーバー情報の配列
     * @return 自オブジェクト
     */
    public NiftyDeregisterInstancesFromSeparateInstanceRuleResult
        withInstances(Instance... instances) {
        if (this.instances == null)
            this.instances = new ArrayList<Instance>();
        for (Instance instance : instances) {
            getInstances().add(instance);
        }
        return this;
    }

    /**
     * 解除に成功したサーバー情報リストを設定し、自オブジェクトを返します。
     *
     * @param instances
     *            解除に成功したサーバー情報リスト
     * @return 自オブジェクト
     */
    public NiftyDeregisterInstancesFromSeparateInstanceRuleResult
        withInstances(Collection<Instance> instances) {
        if (this.instances == null)
            this.instances = new ArrayList<Instance>();
        if (instances != null) {
            getInstances().addAll(instances);
        }
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(", instances=");
        builder.append(instances);
        builder.append("]");
        return builder.toString();
    }

}
