/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteSeparateInstanceRuleリクエストクラス。<br />
 * このクラスはNiftyDeleteSeparateInstanceRuleへのリクエストを構築します。
 *
 */
@Action("NiftyDeleteSeparateInstanceRule")
public class NiftyDeleteSeparateInstanceRuleRequest implements Request {

    /** サーバーセパレート名 */
    private String separateInstanceRuleName;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyDeleteSeparateInstanceRuleRequest() {
    }

    /**
     * サーバーセパレート名を取得します。
     *
     * @return サーバーセパレート名
     */
    @Query(name = "SeparateInstanceRuleName",  require = true)
    public String getSeparateInstanceRuleName() {
        return separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     */
    public void setSeparateInstanceRuleName(String separateInstanceRuleName) {
        this.separateInstanceRuleName = separateInstanceRuleName;
    }

    /**
     * サーバーセパレート名を設定し、自オブジェクトを返します。
     *
     * @param separateInstanceRuleName
     *            サーバーセパレート名
     * @return 自オブジェクト
     */
    public NiftyDeleteSeparateInstanceRuleRequest
        withSeparateInstanceRuleName(String separateInstanceRuleName) {
        setSeparateInstanceRuleName(separateInstanceRuleName);
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[separateInstanceRuleName=");
        builder.append(separateInstanceRuleName);
        builder.append("]");
        return builder.toString();
    }

}
