/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.separate.model.NiftyCreateSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyCreateSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDeleteSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDeleteSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDeregisterInstancesFromSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDeregisterInstancesFromSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDescribeSeparateInstanceRulesRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDescribeSeparateInstanceRulesResult;
import com.nifty.cloud.sdk.separate.model.NiftyRegisterInstancesWithSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyRegisterInstancesWithSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyUpdateSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyUpdateSeparateInstanceRuleResult;

/**
 * NIFCLOUD API クライアント 具象クラス。 サーバーセパレートカテゴリ クライアント。<br />
 * サーバーセパレートカテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public class NiftySeparateClient extends BaseClient implements NiftySeparate {

    /**
     * 認証情報を指定し、サーバーセパレートカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     */
    public NiftySeparateClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    /**
     * 認証情報、クライアント設定を指定し、サーバーセパレートカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftySeparateClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyCreateSeparateInstanceRuleResult
        niftyCreateSeparateInstanceRule(NiftyCreateSeparateInstanceRuleRequest request) {
        return (NiftyCreateSeparateInstanceRuleResult) client.execute(request,
            NiftyCreateSeparateInstanceRuleResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDeleteSeparateInstanceRuleResult
        niftyDeleteSeparateInstanceRule(NiftyDeleteSeparateInstanceRuleRequest request) {
        return (NiftyDeleteSeparateInstanceRuleResult) client.execute(request,
            NiftyDeleteSeparateInstanceRuleResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDeregisterInstancesFromSeparateInstanceRuleResult
        niftyDeregisterInstancesFromSeparateInstanceRule(
            NiftyDeregisterInstancesFromSeparateInstanceRuleRequest request) {
        return (NiftyDeregisterInstancesFromSeparateInstanceRuleResult) client.execute(request,
            NiftyDeregisterInstancesFromSeparateInstanceRuleResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeSeparateInstanceRulesResult
        niftyDescribeSeparateInstanceRules(
            NiftyDescribeSeparateInstanceRulesRequest request) {
        return (NiftyDescribeSeparateInstanceRulesResult) client.execute(request,
            NiftyDescribeSeparateInstanceRulesResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyRegisterInstancesWithSeparateInstanceRuleResult
        niftyRegisterInstancesWithSeparateInstanceRule(
            NiftyRegisterInstancesWithSeparateInstanceRuleRequest request) {
        return (NiftyRegisterInstancesWithSeparateInstanceRuleResult) client.execute(request,
            NiftyRegisterInstancesWithSeparateInstanceRuleResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyUpdateSeparateInstanceRuleResult
        niftyUpdateSeparateInstanceRule(NiftyUpdateSeparateInstanceRuleRequest request) {
        return (NiftyUpdateSeparateInstanceRuleResult) client.execute(request,
            NiftyUpdateSeparateInstanceRuleResult.class);
    }
}
