/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.separate.model.NiftyCreateSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyCreateSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDeleteSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDeleteSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDeregisterInstancesFromSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDeregisterInstancesFromSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDescribeSeparateInstanceRulesRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDescribeSeparateInstanceRulesResult;
import com.nifty.cloud.sdk.separate.model.NiftyRegisterInstancesWithSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyRegisterInstancesWithSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyUpdateSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyUpdateSeparateInstanceRuleResult;

/**
 * NIFCLOUD API 非同期クライアント インタフェース。 サーバーセパレートカテゴリクライアント。<br />
 * サーバーセパレートカテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public interface NiftySeparateAsync extends NiftySeparate {

    /**
     * 非同期でサーバーセパレートを新規作成します。
     *
     * @param request
     *            NiftyCreateSeparateInstanceRuleリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyCreateSeparateInstanceRuleResult>
        niftyCreateSeparateInstanceRuleAsync(NiftyCreateSeparateInstanceRuleRequest request);

    /**
     * 非同期で指定したサーバーセパレートを削除します。
     *
     * @param request
     *            NiftyDeleteSeparateInstanceRuleリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDeleteSeparateInstanceRuleResult>
        niftyDeleteSeparateInstanceRuleAsync(NiftyDeleteSeparateInstanceRuleRequest request);

    /**
     * 非同期で指定したサーバーセパレートの設定情報を取得します。
     *
     * @param request
     *            NiftyDescribeSeparateInstanceRulesリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeSeparateInstanceRulesResult>
        niftyDescribeSeparateInstanceRulesAsync(NiftyDescribeSeparateInstanceRulesRequest request);

    /**
     * 非同期で指定したサーバーセパレートから、指定したサーバーをはずします。
     *
     * @param request
     *            NiftyDeregisterInstancesFromSeparateInstanceRuleリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDeregisterInstancesFromSeparateInstanceRuleResult>
        niftyDeregisterInstancesFromSeparateInstanceRuleAsync(
            NiftyDeregisterInstancesFromSeparateInstanceRuleRequest request);

    /**
     * 非同期で指定したサーバーセパレートを、指定したサーバーへ適用します。
     *
     * @param request
     *            NiftyRegisterInstancesWithSeparateInstanceRuleリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyRegisterInstancesWithSeparateInstanceRuleResult>
        niftyRegisterInstancesWithSeparateInstanceRuleAsync(
            NiftyRegisterInstancesWithSeparateInstanceRuleRequest request);

    /**
     * 非同期で指定したサーバーセパレートの設定情報を更新します。
     *
     * @param request
     *            NiftyUpdateSeparateInstanceRuleリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyUpdateSeparateInstanceRuleResult>
        niftyUpdateSeparateInstanceRuleAsync(NiftyUpdateSeparateInstanceRuleRequest request);
}
