/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.separate;

import com.nifty.cloud.sdk.separate.model.NiftyCreateSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyCreateSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDeleteSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDeleteSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDeregisterInstancesFromSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDeregisterInstancesFromSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyDescribeSeparateInstanceRulesRequest;
import com.nifty.cloud.sdk.separate.model.NiftyDescribeSeparateInstanceRulesResult;
import com.nifty.cloud.sdk.separate.model.NiftyRegisterInstancesWithSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyRegisterInstancesWithSeparateInstanceRuleResult;
import com.nifty.cloud.sdk.separate.model.NiftyUpdateSeparateInstanceRuleRequest;
import com.nifty.cloud.sdk.separate.model.NiftyUpdateSeparateInstanceRuleResult;

/**
 * NIFCLOUD API クライアント インタフェース。 サーバーセパレートカテゴリ クライアント。<br />
 * サーバーセパレートカテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public interface NiftySeparate {

    /**
     * エンドポイントの設定を行います。
     *
     * @param endpoint
     *            エンドポイント
     */
    public void setEndpoint(String endpoint);

    /**
     * サーバーセパレートを新規作成します。
     *
     * @param request
     *            NiftyCreateSeparateInstanceRuleリクエスト
     * @return niftyCreateSeparateInstanceRule処理結果
     */
    public NiftyCreateSeparateInstanceRuleResult
        niftyCreateSeparateInstanceRule(NiftyCreateSeparateInstanceRuleRequest request);

    /**
     * 指定したサーバーセパレートを削除します。
     *
     * @param request
     *            NiftyDeleteSeparateInstanceRuleリクエスト
     * @return niftyDeleteSeparateInstanceRule処理結果
     */
    public NiftyDeleteSeparateInstanceRuleResult
        niftyDeleteSeparateInstanceRule(NiftyDeleteSeparateInstanceRuleRequest request);

    /**
     * 指定したサーバーセパレートの設定情報を取得します。
     *
     * @param request
     *            NiftyDescribeSeparateInstanceRulesリクエスト
     * @return niftyDescribeSeparateInstanceRules処理結果
     */
    public NiftyDescribeSeparateInstanceRulesResult
        niftyDescribeSeparateInstanceRules(NiftyDescribeSeparateInstanceRulesRequest request);

    /**
     * 指定したサーバーセパレートから、指定したサーバーをはずします。
     *
     * @param request
     *            NiftyDeregisterInstancesFromSeparateInstanceRuleリクエスト
     * @return niftyDeregisterInstancesFromSeparateInstanceRule処理結果
     */
    public NiftyDeregisterInstancesFromSeparateInstanceRuleResult
        niftyDeregisterInstancesFromSeparateInstanceRule(
            NiftyDeregisterInstancesFromSeparateInstanceRuleRequest request);

    /**
     * 指定したサーバーセパレートを、指定したサーバーへ適用します。
     *
     * @param request
     *            NiftyRegisterInstancesWithSeparateInstanceRuleリクエスト
     * @return niftyRegisterInstancesWithSeparateInstanceRule処理結果
     */
    public NiftyRegisterInstancesWithSeparateInstanceRuleResult
        niftyRegisterInstancesWithSeparateInstanceRule(
            NiftyRegisterInstancesWithSeparateInstanceRuleRequest request);

    /**
     * 指定したサーバーセパレートの設定情報を更新します。
     *
     * @param request
     *            NiftyUpdateSeparateInstanceRuleリクエスト
     * @return niftyUpdateSeparateInstanceRule処理結果
     */
    public NiftyUpdateSeparateInstanceRuleResult
        niftyUpdateSeparateInstanceRule(NiftyUpdateSeparateInstanceRuleRequest request);

}
