/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.security.model;

import com.nifty.cloud.sdk.Result;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyModifyKeyPairAttribute結果処理クラス。<br />
 * このクラスはNiftyModifyKeyPairAttributeのレスポンスを格納します。
 */
@XStreamAlias("NiftyModifyKeyPairAttributeResponse")
public class NiftyModifyKeyPairAttributeResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** 処理ステータス */
    @XStreamAlias("return")
    private String returnStatus;

    /** 更新対象の項目名 */
    @XStreamAlias("attribute")
    private String attribute;

    /** 更新値 */
    @XStreamAlias("value")
    private String value;

    /**
     * リクエスト識別子を取得します。
     *
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     * 
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     *
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * 処理ステータスを取得します。
     *
     * @return 処理ステータス
     */
    public String getReturnStatus() {
        return returnStatus;
    }

    /**
     * 処理ステータスを設定します。
     *
     * @param returnStatus
     *            処理ステータス
     */
    public void setReturnStatus(String returnStatus) {
        this.returnStatus = returnStatus;
    }

    /**
     * 処理ステータスを設定し、自オブジェクトを返します。
     *
     * @param returnStatus
     *            処理ステータス
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeResult withReturnStatus(String returnStatus) {
        setReturnStatus(returnStatus);
        return this;
    }

    /**
     * 更新対象の項目名を取得します。
     * 
     * @return 更新対象の項目名
     */
    public String getAttribute() {
        return attribute;
    }

    /**
     * 更新対象の項目名を設定します。
     * 
     * @param attribute
     *            更新対象の項目名
     */
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    /**
     * 更新対象の項目名を設定し、自オブジェクトを返します。
     *
     * @param attribute
     *            更新対象の項目名
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeResult withAttribute(String attribute) {
        setAttribute(attribute);
        return this;
    }

    /**
     * 更新値を取得します。
     * 
     * @return 更新値
     */
    public String getValue() {
        return value;
    }

    /**
     * 更新値を設定します。
     *
     * @param value
     *            更新値
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 更新値の項目名を設定し、自オブジェクトを返します。
     *
     * @param value
     *            更新値
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeResult withValue(String value) {
        setValue(value);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(", returnStatus=");
        builder.append(returnStatus);
        builder.append(", attribute=");
        builder.append(attribute);
        builder.append(", value=");
        builder.append(value);
        builder.append("]");
        return builder.toString();
    }

}
