/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.security.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyModifyKeyPairAttributeリクエストクラス。<br />
 * このクラスはNiftyModifyKeyPairAttributeへのリクエストを構築します。
 *
 */
@Action("NiftyModifyKeyPairAttribute")
public class NiftyModifyKeyPairAttributeRequest implements Request {

    /** SSHキー名 */
    private String keyName;

    /** 更新対象の項目名 */
    private String attribute;

    /** 更新値 */
    private String value;

    /**
     * SSHキー名を取得します。
     *
     * @return SSHキー名
     */
    @Query(name = "KeyName", require = true)
    public String getKeyName() {
        return keyName;
    }

    /**
     * SSHキー名を設定します。
     *
     * @param keyName
     *            SSHキー名
     */
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    /**
     * SSHキー名を設定し、自オブジェクトを返します。
     *
     * @param keyName
     *            SSHキー名
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeRequest withKeyName(String keyName) {
        setKeyName(keyName);
        return this;
    }

    /**
     * 更新対象の項目名を取得します。
     * 
     * @return 更新対象の項目名
     */
    @Query(name = "Attribute", require = true)
    public String getAttribute() {
        return attribute;
    }

    /**
     * 更新対象の項目名を設定します。
     * 
     * @param attribute
     *            更新対象の項目名
     */
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    /**
     * 更新対象を設定し、自オブジェクトを返します。
     *
     * @param attribute
     *            更新対象
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeRequest withAttribute(String attribute) {
        setAttribute(attribute);
        return this;
    }

    /**
     * 更新値を取得します。
     * 
     * @return 更新値
     */
    @Query(name = "Value", require = true)
    public String getValue() {
        return value;
    }

    /**
     * 更新値を設定します。
     * 
     * @param value
     *            更新値
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 更新値を設定し、自オブジェクトを返します。
     *
     * @param value
     *            更新値
     * @return 自オブジェクト
     */
    public NiftyModifyKeyPairAttributeRequest withValue(String value) {
        setValue(value);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[keyName=");
        builder.append(keyName);
        builder.append(", attribute=");
        builder.append(attribute);
        builder.append(", value=");
        builder.append(value);
        builder.append("]");
        return builder.toString();
    }

}
