/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.security.model;

import com.nifty.cloud.sdk.Result;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * ImportKeyPair結果処理クラス。<br />
 * このクラスはImportKeyPairのレスポンスを格納します。
 */
@XStreamAlias("ImportKeyPairResponse")
public class ImportKeyPairResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** SSHキー名 */
    @XStreamAlias("keyName")
    private String keyName;

    /** MD5エンコードキー */
    @XStreamAlias("keyFingerprint")
    private String keyFingerprint;

    /**
     * リクエスト識別子を取得します。
     *
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     *
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     *
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public ImportKeyPairResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * SSHキー名を取得します。
     *
     * @return SSHキー名
     */
    public String getKeyName() {
        return keyName;
    }

    /**
     * SSHキー名を設定します。
     *
     * @param keyName
     *            SSHキー名
     */
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    /**
     * SSHキー名を設定し、自オブジェクトを返します。
     *
     * @param keyName
     *            SSHキー名
     * @return 自オブジェクト
     */
    public ImportKeyPairResult withKeyName(String keyName) {
        setKeyName(keyName);
        return this;
    }

    /**
     * MD5エンコードキーを取得します。
     *
     * @return MD5エンコードキー
     */
    public String getKeyFingerprint() {
        return keyFingerprint;
    }

    /**
     * MD5エンコードキーを設定します。
     *
     * @param keyFingerprint
     *            MD5エンコードキー
     */
    public void setKeyFingerprint(String keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }

    /**
     * MD5エンコードキーを設定し、自オブジェクトを返します。
     *
     * @param keyFingerPrint
     *            MD5エンコードキー
     * @return 自オブジェクト
     */
    public ImportKeyPairResult withKeyFingerPrint(String keyFingerprint) {
        setKeyFingerprint(keyFingerprint);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(", keyName=");
        builder.append(keyName);
        builder.append(", keyFingerprint=");
        builder.append(keyFingerprint);
        builder.append("]");
        return builder.toString();
    }

}
