/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.security.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * ImportKeyPairリクエストクラス。<br />
 * このクラスはImportKeyPairへのリクエストを構築します。
 *
 */
@Action("ImportKeyPair")
public class ImportKeyPairRequest implements Request {

    /** SSHキー名 */
    private String keyName;

    /** メモ */
    private String description;

    /** base64エンコードされた公開鍵の文字列 */
    private String publicKeyMaterial;

    /**
     * SSHキー名を取得します。
     *
     * @return SSHキー名
     */
    @Query(name = "KeyName", require = true)
    public String getKeyName() {
        return keyName;
    }

    /**
     * SSHキー名を設定します。
     *
     * @param keyName
     *            SSHキー名
     */
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    /**
     * SSHキー名を設定し、自オブジェクトを返します。
     *
     * @param keyName
     *            SSHキー名
     * @return 自オブジェクト
     */
    public ImportKeyPairRequest withKeyName(String keyName) {
        setKeyName(keyName);
        return this;
    }

    /**
     * メモを取得します。
     *
     * @return メモ
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * メモを設定します。
     *
     * @param description
     *            メモ
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモを設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ
     * @return 自オブジェクト
     */
    public ImportKeyPairRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * base64エンコードされた公開鍵の文字列を取得します。
     *
     * @return base64エンコードされた公開鍵の文字列
     */
    @Query(name = "PublicKeyMaterial", require = true)
    public String getPublicKeyMaterial() {
        return publicKeyMaterial;
    }

    /**
     * base64エンコードされた公開鍵の文字列を設定します。
     *
     * @param publicKeyMaterial
     *            base64エンコードされた公開鍵の文字列
     */
    public void setPublicKeyMaterial(String publicKeyMaterial) {
        this.publicKeyMaterial = publicKeyMaterial;
    }

    /**
     * base64エンコードされた公開鍵の文字列を設定し、自オブジェクトを返します。
     *
     * @param publicKeyMaterial
     *            base64エンコードされた公開鍵の文字列
     * @return 自オブジェクト
     */
    public ImportKeyPairRequest withPublicKeyMaterial(String publicKeyMaterial) {
        setPublicKeyMaterial(publicKeyMaterial);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[keyName=");
        builder.append(keyName);
        builder.append(", description=");
        builder.append(description);
        builder.append(", publicKeyMaterial=");
        builder.append(publicKeyMaterial);
        builder.append("]");
        return builder.toString();
    }
}
