/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.autoscale.NiftyAutoScaleClient;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupResult;

/**
 * NiftyUpdateAutoScalingGroupサンプル
 *
 */
public class NiftyUpdateAutoScalingGroupSample {

    /**
     * NiftyUpdateAutoScalingGroupを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からオートスケールカテゴリ クライアントを生成します。 非同期実行を行う場合はNiftyAutoScaleAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyAutoScaleClient client = new NiftyAutoScaleClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyUpdateAutoScalingGroupを実行します。
         ***********************************************************************/
        NiftyUpdateAutoScalingGroupRequest request = new NiftyUpdateAutoScalingGroupRequest();

        // List<String> securityGroup = new ArrayList<String>();
        // securityGroup.add("securityGroup1"); securityGroup.add("securityGroup2");

        // List<ScalingTrigger> list = new ArrayList<ScalingTrigger>();

        // ScalingTrigger scalingTrigger = new ScalingTrigger();
        // scalingTrigger.withResource("resource1") .withUpperThreshold(Double.valueOf(5.0))
        // .withBreachDuration(Integer.valueOf(3));

        // list.add(scalingTrigger);

        // List<LoadBalancers> loadBalancers = new ArrayList<LoadBalancers>();

        // LoadBalancers loadBalancer1 = new LoadBalancers();
        // loadBalancer1.setName("loadBalancer1");
        // loadBalancer1.setLoadBalancerPort(Integer.valueOf(8081));
        // loadBalancer1.setInstancePort(Integer.valueOf(8082));

        // loadBalancers.add(loadBalancer1);

        // LoadBalancers loadBalancer2 = new LoadBalancers();
        // loadBalancer2.setName("loadBalancer2");
        // loadBalancer2.setLoadBalancerPort(Integer.valueOf(8083));
        // loadBalancer2.setInstancePort(Integer.valueOf(8084));

        // loadBalancers.add(loadBalancer2);

        // List<ScalingSchedule> scalingSchedle = new ArrayList<ScalingSchedule>();

        // ScalingSchedule schedul1 = new ScalingSchedule();

        // TimeZone timeZone1 = new TimeZone(); timeZone1.setStartingTimeZone("12");
        // timeZone1.setEndingTimeZone("15");

        // schedul1.setTimeZone(timeZone1);

        // Day day1 = new Day(); day1.setSunday("1"); day1.setMonday("1"); day1.setTuesday("1");
        // day1.setWednesday("0"); day1.setThursday("0"); day1.setFriday("1");
        // day1.setSaturday("1");

        // schedul1.setDay(day1);

        // DDay dDay1 = new DDay(); dDay1.setStartingDDay("15"); dDay1.setEndingDDay("18");

        // schedul1.setDDay(dDay1);

        // Month month1 = new Month(); month1.setStartingMonth("6"); month1.setEndingMonth("8");

        // schedul1.setMonth(month1);

        // scalingSchedle.add(schedul1);

        // ScalingSchedule schedul2 = new ScalingSchedule();

        // TimeZone timeZone2 = new TimeZone(); timeZone2.setStartingTimeZone("12");
        // timeZone2.setEndingTimeZone("15");

        // schedul2.setTimeZone(timeZone2);

        // Day day2 = new Day(); day2.setSunday("1"); day2.setMonday("1"); day2.setTuesday("1");
        // day2.setWednesday("0"); day2.setThursday("0"); day2.setFriday("1");
        // day2.setSaturday("1");

        // schedul2.setDay(day2);

        // DDay dDay2 = new DDay(); dDay2.setStartingDDay("15"); dDay2.setEndingDDay("18");

        // schedul2.setDDay(dDay2);

        // Month month2 = new Month(); month2.setStartingMonth("6"); month2.setEndingMonth("8");

        // schedul2.setMonth(month2);

        // scalingSchedle.add(schedul2);

        // request.setAutoScalingGroupName("groupName");
        // request.setAutoScalingGroupNameUpdate("groupName10");
        // request.setDescription("description");
        // request.setImageId("imageId");
        // request.setInstanceType("instanceType");
        // request.setSecurityGroup(securityGroup);
        // request.setScalingTrigger(list);
        // request.setScaleoutCondition("condition");
        // request.setLoadBalancers(loadBalancers);
        // request.setMinSize(Integer.valueOf(5));
        // request.setMaxSize(Integer.valueOf(10));
        // request.setInstanceLifecycleLimit(Integer.valueOf(3));
        // request.setScaleout(Integer.valueOf(8));
        // request.setDefaultCooldown(Integer.valueOf(300));
        // request.setChangeInCapacity(Integer.valueOf(2));
        // request.setScalingSchedule(scalingSchedle);

        invokeNiftyUpdateAutoScalingGroup(client, request);

    }

    /**
     * NiftyUpdateAutoScalingGroup 実行サンプル 設定されたリクエストから NiftyUpdateAutoScalingGroup を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyUpdateAutoScalingGroup(NiftyAutoScaleClient client,
        NiftyUpdateAutoScalingGroupRequest request) {
        try {
            NiftyUpdateAutoScalingGroupResult result = client.niftyUpdateAutoScalingGroup(request);

            out.println("NiftyUpdateAutoScalingGroup Action Response");
            out.println(
                "=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId  : " + result.getRequestId());
            }

            if (result.getReturn() != null) {
                out.println("Return     : " + result.getReturn());
            }

            out.println(
                "=============================================================================");

        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
