/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.multiloadbalancer.NiftyMultiLoadBalancerClient;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.ResponseListenerMember;

/**
 * NiftyRegisterPortWithElasticLoadBalancerサンプル
 *
 */
public class NiftyRegisterPortWithElasticLoadBalancerSample {

    /**
     * NiftyRegisterPortWithElasticLoadBalancerを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からマルチロードバランサーカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyMultiLoadBalancerAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyMultiLoadBalancerClient client = new NiftyMultiLoadBalancerClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyRegisterPortWithElasticLoadBalancerを実行します。
         ***********************************************************************/
        NiftyRegisterPortWithElasticLoadBalancerRequest request =
            new NiftyRegisterPortWithElasticLoadBalancerRequest();

//        RequestListener listener = new RequestListener();

//        List<RequestListenerMember> member = new ArrayList<RequestListenerMember>();

//        RequestListenerMember member1 = new RequestListenerMember();
//        member1.setProtocol("https");
//        member1.setElasticLoadBalancerPort(Integer.valueOf(8081));
//        member1.setInstancePort(Integer.valueOf(8082));
//        member1.setBalancingType("1");
//        member1.setDescription("テスト１");

//        RequestListenerMember member2 = new RequestListenerMember();
//        member2.setProtocol("https");
//        member2.setElasticLoadBalancerPort(Integer.valueOf(8084));
//        member2.setInstancePort(Integer.valueOf(8084));
//        member2.setBalancingType("2");
//        member2.setDescription("テスト２");

//        member.add(member1);
//        member.add(member2);

//        listener.setMember(member);

//        request.setListener(listener);

//        request.setElasticLoadBalancerId("loadBalancerId");
//        request.setElasticLoadBalancerName("loadBalancerName");
//        request.setListener(listener);

        invokeNiftyRegisterPortWithElasticLoadBalancer(client, request);

    }

    /**
     * NiftyRegisterPortWithElasticLoadBalancer 実行サンプル 設定されたリクエストから
     * NiftyRegisterPortWithElasticLoadBalancer を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyRegisterPortWithElasticLoadBalancer(
        NiftyMultiLoadBalancerClient client,
        NiftyRegisterPortWithElasticLoadBalancerRequest request) {
        try {
            NiftyRegisterPortWithElasticLoadBalancerResult result =
                client.niftyRegisterPortWithElasticLoadBalancer(request);

            out.println("NiftyRegisterPortWithElasticLoadBalancer Action Response");
            out.println(
                "=============================================================================");

            List<ResponseListenerMember> list = null;

            list = result.getListener().getMember();

            if (list != null && list.size() > 0) {

                for (ResponseListenerMember member : list) {

                    out.println("Listener");

                    if (member.getProtocol() != null) {
                        out.println("  Protocol               :" + member.getProtocol());
                    }

                    if (member.getElasticLoadBalancerPort() != null) {
                        out.println(
                            "  ElasticLoadBalancerPort:" + member.getElasticLoadBalancerPort());
                    }

                    if (member.getInstancePort() != null) {
                        out.println("  InstancePort           :" + member.getInstancePort());
                    }

                    if (member.getBalancingType() != null) {
                        out.println("  BalancingType          :" + member.getBalancingType());
                    }

                    if (member.getDescription() != null) {
                        out.println("  Description            :" + member.getDescription());
                    }

                }

            }

            out.println(
                "=============================================================================");

        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }

    }
}
