/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.proxy.NiftyProxyClient;
import com.nifty.cloud.sdk.proxy.model.NetworkInterface;
import com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesRequest;
import com.nifty.cloud.sdk.proxy.model.NiftyDescribeWebProxiesResult;
import com.nifty.cloud.sdk.proxy.model.WebProxy;
import com.nifty.cloud.sdk.proxy.model.WebProxyOption;

/**
 * NiftyDescribeWebProxiesサンプル
 *
 */
public class NiftyDescribeWebProxiesSample {

    /**
     * NiftyDescribeWebProxiesを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からプロキシカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyProxyAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyProxyClient client = new NiftyProxyClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeWebProxiesを実行します。
         ***********************************************************************/
        NiftyDescribeWebProxiesRequest request = new NiftyDescribeWebProxiesRequest();
        invokeNiftyDescribeWebProxies(client, request);

    }

    /**
     * NiftyDescribeWebProxies 実行サンプル
     * 設定されたリクエストから NiftyDescribeWebProxies を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeNiftyDescribeWebProxies(NiftyProxyClient client,
            NiftyDescribeWebProxiesRequest request) {
        try {
            NiftyDescribeWebProxiesResult result = client.niftyDescribeWebProxies(request);

            out.println("NiftyDescribeWebProxies Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId        : " + result.getRequestId());
            }
            if (result.getWebProxies() != null) {
                List<WebProxy> webProxies = result.getWebProxies();
                for (WebProxy webProxy : webProxies) {
                    out.println("WebProxies");
                    if (webProxy.getRouterId() != null) {
                        out.println("  RouterId       : " + webProxy.getRouterId());
                    }
                    if (webProxy.getRouterName() != null) {
                        out.println("  RouterName     : " + webProxy.getRouterName());
                    }
                    if (webProxy.getListenInterface() != null) {
                        NetworkInterface listenInterface = webProxy.getListenInterface();
                        out.println("  ListenInterface");
                        if (listenInterface.getNetworkId() != null) {
                            out.println("    NetworkId    : " + listenInterface.getNetworkId());
                        }
                        if (listenInterface.getNetworkName() != null) {
                            out.println("    NetworkName  : " + listenInterface.getNetworkName());
                        }
                    }
                    if (webProxy.getListenPort() != null) {
                        out.println("  ListenPort     : " + webProxy.getListenPort());
                    }
                    if (webProxy.getBypassInterface() != null) {
                        NetworkInterface bypassInterface = webProxy.getBypassInterface();
                        out.println("  BypassInterface");
                        if (bypassInterface.getNetworkId() != null) {
                            out.println("    NetworkId    : " + bypassInterface.getNetworkId());
                        }
                        if (bypassInterface.getNetworkName() != null) {
                            out.println("    NetworkName  : " + bypassInterface.getNetworkName());
                        }
                    }
                    if (webProxy.getOption() != null) {
                        WebProxyOption webProxyOption = webProxy.getOption();
                        out.println("  Option");
                        if (webProxyOption.getNameServer() != null) {
                            out.println("    NameServer   : " + webProxyOption.getNameServer());
                        }
                    }
                    if (webProxy.getDescription() != null) {
                        out.println("  Description    : " + webProxy.getDescription());
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
