/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.router.NiftyRouterClient;
import com.nifty.cloud.sdk.router.model.BackupInformation;
import com.nifty.cloud.sdk.router.model.NetworkInterfaceSet;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersRequest;
import com.nifty.cloud.sdk.router.model.NiftyDescribeRoutersResult;
import com.nifty.cloud.sdk.router.model.Router;
import com.nifty.cloud.sdk.router.model.Tag;
import com.nifty.cloud.sdk.router.model.VersionInformation;

/**
 * NiftyDescribeRoutersサンプル
 *
 */
public class NiftyDescribeRoutersSample {

    /**
     * NiftyDescribeRoutersを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からルーターカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyRouterAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyRouterClient client = new NiftyRouterClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeRoutersを実行します。
         ***********************************************************************/
        NiftyDescribeRoutersRequest request = new NiftyDescribeRoutersRequest();
        invokeNiftyDescribeRouters(client, request);

    }

    /**
     * NiftyDescribeRouters 実行サンプル
     * 設定されたリクエストから NiftyDescribeRouters を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeNiftyDescribeRouters(NiftyRouterClient client,
            NiftyDescribeRoutersRequest request) {
        try {
            NiftyDescribeRoutersResult result = client.niftyDescribeRouters(request);

            out.println("NiftyDescribeRouters Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId                   : " + result.getRequestId());
            }
            if (result.getRouters() != null) {
                List<Router> routers = result.getRouters();
                for (Router router : routers) {
                    out.println("Router");
                    if (router.getRouterId() != null) {
                        out.println("  RouterId                  : " + router.getRouterId());
                    }
                    if (router.getRouterName() != null) {
                        out.println("  RouterName                : " + router.getRouterName());
                    }
                    if (router.getState() != null) {
                        out.println("  State                     : " + router.getState());
                    }
                    if (router.getAvailabilityZone() != null) {
                        out.println("  AvailabilityZone          : " + router.getAvailabilityZone());
                    }
                    if (router.getTagSet() != null) {
                        List<Tag> tagSet =router.getTagSet();
                        for (Tag tag : tagSet) {
                            out.println("  TagSet");
                            if (tag.getKey() != null) {
                                out.println("    Key                     : " + tag.getKey());
                            }
                            if (tag.getValue() != null) {
                            out.println("    Value                   : " + tag.getValue());
                            }
                        }
                    }
                    if (router.getAccountingType() != null) {
                        out.println("  AccountingType            : " + router.getAccountingType());
                    }
                    if (router.getNextMonthAccountingType() != null) {
                        out.println("  NextMonthAccountingType   : " + router.getNextMonthAccountingType());
                    }
                    if (router.getDescription() != null) {
                        out.println("  Description               : " + router.getDescription());
                    }
                    if (router.getVersionInformation() != null) {
                        VersionInformation versionInformation = router.getVersionInformation();
                        out.println("  VersionInformation");
                        if (versionInformation.getIsLatest() != null) {
                            out.println("    IsLatest                : " + versionInformation.getIsLatest());
                        }
                        if (versionInformation.getVersion() != null) {
                            out.println("    Version                 : " + versionInformation.getVersion());
                        }
                    }
                    if (router.getNetworkInterfaces() != null) {
                        List<NetworkInterfaceSet> networkInterfaces = router.getNetworkInterfaces();
                        for (NetworkInterfaceSet networkInterface : networkInterfaces) {
                            out.println("  NetworkInterfaces");
                            if (networkInterface.getNetworkId() != null) {
                                out.println("    NetworkId               : " + networkInterface.getNetworkId());
                            }
                            if (networkInterface.getNetworkName() != null) {
                                out.println("    NetworkName             : " + networkInterface.getNetworkName());
                            }
                            if (networkInterface.getDeviceIndex() != null) {
                                out.println("    DeviceIndex             : " + networkInterface.getDeviceIndex());
                            }
                            if (networkInterface.getIpAddress() != null) {
                                out.println("    IpAddress               : " + networkInterface.getIpAddress());
                            }
                            if (networkInterface.getCidrBlock() != null) {
                                out.println("    CidrBlock               : " + networkInterface.getCidrBlock());
                            }
                            if (networkInterface.getDhcp() != null) {
                                out.println("    Dhcp                    : " + networkInterface.getDhcp());
                            }
                            if (networkInterface.getDhcpOptionsId() != null) {
                                out.println("    DhcpOptionsId           : " + networkInterface.getDhcpOptionsId());
                            }
                            if (networkInterface.getDhcpConfigId() != null) {
                                out.println("    DhcpConfigId            : " + networkInterface.getDhcpConfigId());
                            }
                            if (networkInterface.getDescription() != null) {
                                out.println("    Description             : " + networkInterface.getDescription());
                            }
                        }
                    }
                    if (router.getRouteTableId() != null) {
                        out.println("  RouteTableId              : " + router.getRouteTableId());
                    }
                    if (router.getRouteTableAssociationId() != null) {
                        out.println("  RouteTableAssociationId   : " + router.getRouteTableAssociationId());
                    }
                    if (router.getNatTableId() != null) {
                        out.println("  NatTableId                : " + router.getNatTableId());
                    }
                    if (router.getNatTableAssociationId() != null) {
                        out.println("  NatTableAssociationId     : " + router.getNatTableAssociationId());
                    }
                    if (router.getBackupInformation() != null) {
                        BackupInformation backupInformation = router.getBackupInformation();
                        out.println("  BackupInformation");
                        if (backupInformation.getIsBackup() != null) {
                            out.println("    IsBackup                : " + backupInformation.getIsBackup());
                        }
                        if (backupInformation.getExpirationDate() != null) {
                            out.println("    ExpirationDate          : " + backupInformation.getExpirationDate());
                        }
                    }
                    if (router.getType() != null) {
                        out.println("  Type                      : " + router.getType());
                    }
                    if (router.getGroupIds() != null) {
                        List<String> groupIds = router.getGroupIds();
                        for (String groupId : groupIds){
                            out.println("  GroupIds");
                            out.println("    GroupId                 : " + groupId);
                        }
                    }
                    if (router.getCreatedTime() != null) {
                         out.println("  CreatedTime               : " + router.getCreatedTime());
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
