/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.privatelan.NiftyPrivateLanClient;
import com.nifty.cloud.sdk.privatelan.model.ElasticLoadBalancing;
import com.nifty.cloud.sdk.privatelan.model.Instance;
import com.nifty.cloud.sdk.privatelan.model.NetworkInterface;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansResult;
import com.nifty.cloud.sdk.privatelan.model.PrivateLan;
import com.nifty.cloud.sdk.privatelan.model.Router;
import com.nifty.cloud.sdk.privatelan.model.Tag;
import com.nifty.cloud.sdk.privatelan.model.VpnGateway;

public class NiftyDescribePrivateLansSample {
    /**
     * NiftyDescribePrivateLansを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からサーバーカテゴリ クライアントを生成します。 非同期実行を行う場合はNiftyPrivateLanClientクラスを指定します。
         ***********************************************************************/
        NiftyPrivateLanClient client = new NiftyPrivateLanClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribePrivateLansを実行します。
         ***********************************************************************/
        NiftyDescribePrivateLansRequest request = new NiftyDescribePrivateLansRequest();
        // List<String> networkIds = new ArrayList<String>();
        // networkIds.add("net-8db04f81");
        // networkIds.add("net-8db04f82");
        // request.setNetworkIds(networkIds);
        // List<String> privateLanNames = new ArrayList<String>();
        // privateLanNames.add("privateLanName1");
        // privateLanNames.add("privateLanName2");
        // request.setPrivateLanNames(privateLanNames);
        invokeNiftyDescribePrivateLans(client, request);
    }

    /**
     * NiftyDescribePrivateLans 実行サンプル 設定されたリクエストから NiftyDescribePrivateLans を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyDescribePrivateLans(NiftyPrivateLanClient client,
        NiftyDescribePrivateLansRequest request) {
        try {
            NiftyDescribePrivateLansResult result = client.niftyDescribePrivateLans(request);

            out.println("NiftyDescribePrivateLans Action Response");
            out.println(
                "=============================================================================");
            if (result.getPrivateLans() != null) {
                List<PrivateLan> privateLans = result.getPrivateLans();
                for (PrivateLan privateLan : privateLans) {
                    out.println("PrivateLans");
                    if (privateLan.getNetworkId() != null) {
                        out.println("  NetworkId                : " + privateLan.getNetworkId());
                    }
                    if (privateLan.getPrivateLanName() != null) {
                        out.println(
                            "  PrivateLanName           : " + privateLan.getPrivateLanName());
                    }
                    if (privateLan.getState() != null) {
                        out.println("  State                    : " + privateLan.getState());
                    }
                    if (privateLan.getCidrBlock() != null) {
                        out.println("  CidrBlock                : " + privateLan.getCidrBlock());
                    }
                    if (privateLan.getAvailabilityZone() != null) {
                        out.println(
                            "  AvailabilityZone         : " + privateLan.getAvailabilityZone());
                    }
                    if (privateLan.getTagSets() != null) {
                        List<Tag> tagSets = privateLan.getTagSets();
                        for (Tag tagSet : tagSets) {
                            out.println("  TagSet");
                            if (tagSet.getKey() != null) {
                                out.println("    Key                    : " + tagSet.getKey());
                            }
                            if (tagSet.getValue() != null) {
                                out.println("    Value                  : " + tagSet.getValue());
                            }
                        }
                    }
                    if (privateLan.getAccountingType() != null) {
                        out.println(
                            "  AccountingType           : " + privateLan.getAccountingType());
                    }
                    if (privateLan.getNextMonthAccountingType() != null) {
                        out.println("  NextMonthAccountingType  : "
                            + privateLan.getNextMonthAccountingType());
                    }
                    if (privateLan.getDescription() != null) {
                        out.println("  Description              : " + privateLan.getDescription());
                    }
                    if (privateLan.getInstanceSets() != null) {
                        List<Instance> instanceSets = privateLan.getInstanceSets();
                        for (Instance instanceSet : instanceSets) {
                            out.println("  InstanceSet");
                            if (instanceSet.getInstanceUniqueId() != null) {
                                out.println("    InstanceUniqueId       : "
                                    + instanceSet.getInstanceUniqueId());
                            }
                            if (instanceSet.getInstanceId() != null) {
                                out.println(
                                    "    InstanceId             : " + instanceSet.getInstanceId());
                            }
                            if (instanceSet.getDeviceIndex() != null) {
                                out.println(
                                    "    DeviceIndex            : " + instanceSet.getDeviceIndex());
                            }
                            if (instanceSet.getIpAddress() != null) {
                                out.println(
                                    "    IpAddress              : " + instanceSet.getIpAddress());
                            }
                        }
                    }
                    if (privateLan.getRouterSets() != null) {
                        List<Router> routerSets = privateLan.getRouterSets();
                        for (Router routerSet : routerSets) {
                            out.println("  RouterSet");
                            if (routerSet.getRouterId() != null) {
                                out.println(
                                    "    RouterId               : " + routerSet.getRouterId());
                            }
                            if (routerSet.getRouterName() != null) {
                                out.println(
                                    "    RouterName             : " + routerSet.getRouterName());
                            }
                            if (routerSet.getDeviceIndex() != null) {
                                out.println(
                                    "    DeviceIndex            : " + routerSet.getDeviceIndex());
                            }
                            if (routerSet.getIpAddress() != null) {
                                out.println(
                                    "    IpAddress              : " + routerSet.getIpAddress());
                            }
                        }
                    }
                    if (privateLan.getVpnGatewaySets() != null) {
                        List<VpnGateway> vpnGatewaySets = privateLan.getVpnGatewaySets();
                        for (VpnGateway vpnGatewaySet : vpnGatewaySets) {
                            out.println(" VpnGatewaySet");
                            if (vpnGatewaySet.getVpnGatewayId() != null) {
                                out.println("    VpnGatewayId           : "
                                    + vpnGatewaySet.getVpnGatewayId());
                            }
                            if (vpnGatewaySet.getNiftyVpnGatewayName() != null) {
                                out.println("    NiftyVpnGatewayName    : "
                                    + vpnGatewaySet.getNiftyVpnGatewayName());
                            }
                            if (vpnGatewaySet.getDeviceIndex() != null) {
                                out.println("    DeviceIndex            : "
                                    + vpnGatewaySet.getDeviceIndex());
                            }
                            if (vpnGatewaySet.getIpAddress() != null) {
                                out.println(
                                    "    IpAddress              : " + vpnGatewaySet.getIpAddress());
                            }
                        }
                    }
                    if (privateLan.getElasticLoadBalancingSets() != null) {
                        List<ElasticLoadBalancing> elasticLoadBalancingSets =
                            privateLan.getElasticLoadBalancingSets();
                        for (ElasticLoadBalancing elasticLoadBalancingSet : elasticLoadBalancingSets) {
                            out.println(" ElasticLoadBalancing");
                            if (elasticLoadBalancingSet.getElasticLoadBalancerName() != null) {
                                out.println("    ElasticLoadBalancerName: "
                                    + elasticLoadBalancingSet.getElasticLoadBalancerName());
                            }
                            if (elasticLoadBalancingSet.getProtocol() != null) {
                                out.println(
                                    "    Protocol               : " + elasticLoadBalancingSet.getProtocol());
                            }
                            if (elasticLoadBalancingSet.getElasticLoadBalancerPort() != null) {
                                out.println("    ElasticLoadBalancerPort: "
                                    + elasticLoadBalancingSet.getElasticLoadBalancerPort());
                            }
                            if (elasticLoadBalancingSet.getInstancePort() != null) {
                                out.println("    InstancePort           : "
                                    + elasticLoadBalancingSet.getInstancePort());
                            }
                        }
                    }
                    if (privateLan.getNetworkInterfaceSets() != null) {
                        List<NetworkInterface> networkInterfaceSets =
                            privateLan.getNetworkInterfaceSets();
                        for (NetworkInterface networkInterfaceSet : networkInterfaceSets) {
                            out.println(" NetworkInterfaceSet");
                            if (networkInterfaceSet.getNetworkInterfaceId() != null) {
                                out.println("    NetworkInterfaceId     : "
                                    + networkInterfaceSet.getNetworkInterfaceId());
                            }
                            if (networkInterfaceSet.getIpAddress() != null) {
                                out.println(
                                    "    IpAddress              : " + networkInterfaceSet.getIpAddress());
                            }
                        }
                    }
                    if (privateLan.getCreatedTime() != null) {
                        out.println("  CreatedTime              : " + privateLan.getCreatedTime());
                    }
                    if (privateLan.getSharingStatus() != null) {
                        out.println(
                            "  SharingStatus            : " + privateLan.getSharingStatus());
                    }
                }
            }
            out.println(
                "=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
