/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import java.util.List;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureMethod;
import com.nifty.cloud.sdk.auth.SignatureUtils.SignatureVersion;
import com.nifty.cloud.sdk.snapshot.NiftySnapshotClient;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsRequest;
import com.nifty.cloud.sdk.snapshot.model.NiftyDescribeInstanceSnapshotsResult;
import com.nifty.cloud.sdk.snapshot.model.SnapshotInfo;

/**
 * NiftyDescribeInstanceSnapshotsサンプル
 *
 */
public class NiftyDescribeInstanceSnapshotsSample {

    /**
     * NiftyDescribeInstanceSnapshotsを実行するサンプルです。
     * 必要なパラメーターを設定してから利用してください。
     *
     * @param args  利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。
         * 設定情報を変更する場合は値を設定します。
         * 以下の項目について設定可能です。
         *   - ユーザーエージェント
         *   - プロトコル
         *   - プロキシサーバーアドレス
         *   - プロキシサーバーポート番号
         *   - プロキシユーザー名
         *   - プロキシパスワード
         *   - 最大リトライ回数
         *   - 最大接続数
         *   - TCPソケットタイムアウト秒数
         *   - 接続タイムアウト秒数
         *   - 送信バッファサイズ / 受信バッファサイズ
         *   - SignatureVersion
         *   - SignatureMethod
         *     HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からスナップショットカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftySnapshotAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftySnapshotClient client = new NiftySnapshotClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeInstanceSnapshotsを実行します。
         ***********************************************************************/
        NiftyDescribeInstanceSnapshotsRequest request = new NiftyDescribeInstanceSnapshotsRequest();
        invokeNiftyDescribeInstanceSnapshots(client, request);

    }

    /**
     * NiftyDescribeInstanceSnapshots 実行サンプル
     * 設定されたリクエストから NiftyDescribeInstanceSnapshots を実行し、実行結果を表示します。
     *
     * @param client   クライアント
     * @param request  リクエスト
     */
    public static void invokeNiftyDescribeInstanceSnapshots(NiftySnapshotClient client,
            NiftyDescribeInstanceSnapshotsRequest request) {
        try {
            NiftyDescribeInstanceSnapshotsResult result = client.niftyDescribeInstanceSnapshots(request);

            out.println("NiftyDescribeInstanceSnapshots Action Response");
            out.println("=============================================================================");
            if (result.getRequestId() != null) {
                out.println("RequestId            : " + result.getRequestId());
            }
            if (result.getSnapshots() != null) {
                List<SnapshotInfo> snapshots = result.getSnapshots();
                for (SnapshotInfo snapshot : snapshots) {
                    out.println("SnapshotInfoSet");
                    if (snapshot.getInstanceSnapshotId() != null) {
                        out.println("  InstanceSnapshotId : " + snapshot.getInstanceSnapshotId());
                    }
                    if (snapshot.getSnapshotName() != null) {
                        out.println("  SnapshotName       : " + snapshot.getSnapshotName());
                    }
                    if (snapshot.getPowerStatus() != null) {
                        out.println("  PowerStatus        : " + snapshot.getPowerStatus());
                    }
                    if (snapshot.getMemo() != null) {
                        out.println("  Memo               : " + snapshot.getMemo());
                    }
                    if (snapshot.getCreatedTime() != null) {
                        out.println("  CreatedTime        : " + snapshot.getCreatedTime());
                    }
                    if (snapshot.getUpdatedTime() != null) {
                        out.println("  UpdatedTime        : " + snapshot.getUpdatedTime());
                    }
                    if (snapshot.getExpiredTime() != null) {
                        out.println("  ExpiredTime        : " + snapshot.getExpiredTime());
                    }
                    if (snapshot.getInstanceId() != null) {
                        out.println("  InstanceId         : " + snapshot.getInstanceId());
                    }
                    if (snapshot.getStatus() != null) {
                        out.println("  Status             : " + snapshot.getStatus());
                    }
                    if (snapshot.getDifference() != null) {
                        out.println("  Difference         : " + snapshot.getDifference());
                    }
                }
            }
            out.println("=============================================================================");
        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
