/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.sample;

import static java.lang.System.*;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.auth.BasicCredentials;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.multiloadbalancer.NiftyMultiLoadBalancerClient;
import com.nifty.cloud.sdk.multiloadbalancer.model.DescriptionMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.ElasticLoadBalancerDescriptions;
import com.nifty.cloud.sdk.multiloadbalancer.model.ElasticLoadBalancerDescriptionsMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.ExpectationMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.ListenerDescribe;
import com.nifty.cloud.sdk.multiloadbalancer.model.NetworkInterface;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.ServerMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.SystemIpAddress;

/**
 * NiftyDescribeElasticLoadBalancersサンプル
 *
 */
public class NiftyDescribeElasticLoadBalancersSample {

    /**
     * NiftyDescribeElasticLoadBalancersを実行するサンプルです。 必要なパラメーターを設定してから利用してください。
     *
     * @param args
     *            利用しない
     */
    public static void main(String[] args) {

        /************************************************************************
         * AccessKeyとSecretAccessKeyを設定します。 キーはNIFCLOUDのコントロールパネルから取得します。
         ***********************************************************************/
        String accessKey = "<Input Your AccessKey>";
        String secretKey = "<Input Your SecretAccessKey>";

        /************************************************************************
         * 指定されたAccessKeyとSecretAccessKeyから認証情報インスタンスを生成します。
         ***********************************************************************/
        Credentials credential = new BasicCredentials(accessKey, secretKey);

        /************************************************************************
         * クライアント設定情報インスタンスを生成します。 設定情報を変更する場合は値を設定します。 以下の項目について設定可能です。 - ユーザーエージェント - プロトコル -
         * プロキシサーバーアドレス - プロキシサーバーポート番号 - プロキシユーザー名 - プロキシパスワード - 最大リトライ回数 - 最大接続数 - TCPソケットタイムアウト秒数
         * - 接続タイムアウト秒数 - 送信バッファサイズ / 受信バッファサイズ - SignatureVersion - SignatureMethod HTTPメソッド
         ***********************************************************************/
        ClientConfiguration config = new ClientConfiguration();
        // config.setUserAgent("NIFCLOUD API Java SDK");
        // config.setProtocol(Protocol.HTTPS);
        // config.setProxyHost("proxy_host");
        // config.setProxyPort(0);
        // config.setProxyUsername("proxy_username");
        // config.setProxyPassword("proxy_password");
        // config.setMaxErrorRetry(3);
        // config.setMaxConnections(50);
        // config.setSocketTimeout(30);
        // config.setConnectionTimeout(30);
        // config.setSocketSendBufferSizeHint(0, 0);
        // config.setSignatureVersion(SignatureVersion.Version_2);
        // config.setSignatureMethod(SignatureMethod.HmacSHA256);
        // config.setRequestMethod("GET");

        /************************************************************************
         * 認証情報とクライアント設定情報からマルチロードバランサーカテゴリ クライアントを生成します。
         * 非同期実行を行う場合はNiftyMultiLoadBalancerAsyncClientクラスを指定します。
         ***********************************************************************/
        NiftyMultiLoadBalancerClient client = new NiftyMultiLoadBalancerClient(credential, config);

        /************************************************************************
         * 接続先URLを変更する場合は接続先を指定します。
         ***********************************************************************/
        // client.setEndpoint("endpoint_url");

        /************************************************************************
         * リクエストパラメーターを設定し、NiftyDescribeElasticLoadBalancersを実行します。
         ***********************************************************************/
        NiftyDescribeElasticLoadBalancersRequest request =
            new NiftyDescribeElasticLoadBalancersRequest();

        // ElasticLoadBalancers loadBalancers = new ElasticLoadBalancers();

        // List<String> valueList1 = new ArrayList<String>();
        // valueList1.add("test1");
        // valueList1.add("test2");

        // List<String> valueList2 = new ArrayList<String>();
        // valueList2.add("test3");
        // valueList2.add("test4");

        // List<Filter> filterList = new ArrayList<Filter>();

        // Filter filter1 = new Filter();
        // filter1.setName("name1");
        // filter1.setValue(valueList1);

        // filterList.add(filter1);

        // Filter filter2 = new Filter();
        // filter2.setName("name2");
        // filter2.setValue(valueList2);

        // filterList.add(filter2);

        // request.setElasticLoadBalancers(loadBalancers);
        // request.setFilter(filterList);

        invokeNiftyDescribeElasticLoadBalancers(client, request);

    }

    /**
     * NiftyDescribeElasticLoadBalancers 実行サンプル 設定されたリクエストから NiftyDescribeElasticLoadBalancers
     * を実行し、実行結果を表示します。
     *
     * @param client
     *            クライアント
     * @param request
     *            リクエスト
     */
    public static void invokeNiftyDescribeElasticLoadBalancers(
        NiftyMultiLoadBalancerClient client,
        NiftyDescribeElasticLoadBalancersRequest request) {
        try {
            NiftyDescribeElasticLoadBalancersResult result =
                client.niftyDescribeElasticLoadBalancers(request);

            ElasticLoadBalancerDescriptions descriptions =
                result.getElasticLoadBalancerDescriptions();

            out.println("NiftyDescribeElasticLoadBalancers Action Response");
            out.println(
                "=============================================================================");

            out.println("  NiftyDescribeElasticLoadBalancersResult");

            for(ElasticLoadBalancerDescriptionsMember work : descriptions.getMember()) {

                if (work.getElasticLoadBalancerId() != null) {
                    out.println(
                        "    ElasticLoadBalancerId  :" + work.getElasticLoadBalancerId());
                }

                if (work.getElasticLoadBalancerName() != null) {
                    out.println(
                        "    ElasticLoadBalancerName:" + work.getElasticLoadBalancerName());
                }

                if (work.getDnsName() != null) {
                    out.println("    DnsName                :" + work.getDnsName());
                }

                if (work.getNetworkVolume() != null) {
                    out.println("    NetworkVolume          :" + work.getNetworkVolume());
                }

                if (work.getState() != null) {
                    out.println("    State                  :" + work.getState());
                }

                if (work.getAccountingType() != null) {
                    out.println("    AccountingType         :" + work.getAccountingType());
                }

                if (work.getNextMonthAccountingType() != null) {
                    out.println(
                        "    NextMonthAccountingType:" + work.getNextMonthAccountingType());
                }

                if (work.getElasticLoadBalancerListenerDescriptions() != null) {

                    if (work.getElasticLoadBalancerListenerDescriptions().getMemberList()
                        .size() > 0) {

                        for (DescriptionMember member : work
                            .getElasticLoadBalancerListenerDescriptions().getMemberList()) {

                            ListenerDescribe listener = member.getListenerDescribe();

                            if (listener.getProtocol() != null) {
                                out.println("      Protocol               :" + listener.getProtocol());
                            }

                            if (listener.getElasticLoadBalancerPort() != null) {
                                out.println("      ElasticLoadBalancerPort:"
                                    + Integer.toString(listener.getElasticLoadBalancerPort()));
                            }

                            if (listener.getInstancePort() != null) {
                                out.println("      InstancePort           :"
                                    + Integer.toString(listener.getInstancePort()));
                            }

                            if (listener.getBalancingType() != null) {
                                out.println(
                                    "      BalancingType          :" + listener.getBalancingType());
                            }

                            if (listener.getDescription() != null) {
                                out.println(
                                    "      Description            :" + listener.getDescription());
                            }

                            if (listener.getSslCertificateId() != null) {
                                out.println(
                                    "      SSLCertificateId       :" + listener.getSslCertificateId());
                            }

                            out.println("      SessionStickinessPolicy");

                            if (listener.getStickinessPolicy().getEnable() != null) {
                                out.println(
                                    "        Enable          :"
                                        + listener.getStickinessPolicy().getEnable());
                            }

                            if (listener.getStickinessPolicy().getMethod() != null) {
                                out.println(
                                    "        Method          :"
                                        + listener.getStickinessPolicy().getMethod());
                            }

                            if (listener.getStickinessPolicy().getExpirationPeriod() != null) {
                                out.println("        ExpirationPeriod:"
                                    + listener.getStickinessPolicy().getExpirationPeriod());
                            }

                            out.println("      SorryPage");

                            if (listener.getSorryPage().getEnable() != null) {
                                out.println(
                                    "        Enable     :" + listener.getSorryPage().getEnable());
                            }

                            if (listener.getSorryPage().getRedirectUrl() != null) {
                                out.println(
                                    "        RedirectUrl:" + listener.getSorryPage().getRedirectUrl());
                            }

                            out.println("      Instances");

                            if (listener.getInstances().getMemberList() != null) {

                                for (ServerMember serverMember : listener.getInstances()
                                    .getMemberList()) {

                                    if (serverMember.getInstanceUniqueId() != null) {
                                        out.println("        InstanceUniqueId:"
                                            + serverMember.getInstanceUniqueId());
                                    }

                                    if (serverMember.getInstanceId() != null) {
                                        out.println("        InstanceId      :"
                                            + serverMember.getInstanceId());
                                    }

                                }

                            }

                            out.println("      HealthCheck");

                            if (listener.getHealthCheck().getTarget() != null) {
                                out.println("        Target            :"
                                    + listener.getHealthCheck().getTarget());
                            }

                            if (listener.getHealthCheck().getInterval() != null) {
                                out.println(
                                    "        Interval          :"
                                        + listener.getHealthCheck().getInterval());
                            }

                            if (listener.getHealthCheck().getTimeout() != null) {
                                out.println(
                                    "        Timeout           :"
                                        + listener.getHealthCheck().getTimeout());
                            }

                            if (listener.getHealthCheck().getUnhealthyThreshold() != null) {
                                out.println("        UnhealthyThreshold:"
                                    + listener.getHealthCheck().getUnhealthyThreshold());
                            }

                            if (listener.getHealthCheck().getHealthyThreshold() != null) {
                                out.println("        HealthyThreshold  :"
                                    + listener.getHealthCheck().getHealthyThreshold());
                            }

                            if (listener.getHealthCheck().getPath() != null) {
                                out.println("        Path              :"
                                    + listener.getHealthCheck().getPath());
                            }

                            out.println("        Expectation");

                            if (listener.getHealthCheck().getExpectation() != null &&
                                listener.getHealthCheck().getExpectation().getMemberList() != null) {

                                for (ExpectationMember expectationMember : listener.getHealthCheck()
                                    .getExpectation().getMemberList()) {

                                    if (expectationMember.getHttpCode() != null) {
                                        out.println("          HttpCode:"
                                            + expectationMember.getHttpCode());
                                    }

                                }

                            }

                            out.println("        InstanceStates");

                            if (listener.getHealthCheck().getInstance().getMemberList() != null) {

                                for (ServerMember serverMember : listener.getHealthCheck().getInstance()
                                    .getMemberList()) {

                                    if (serverMember.getInstanceUniqueId() != null) {
                                        out.println("          InstanceUniqueId:"
                                            + serverMember.getInstanceUniqueId());
                                    }

                                    if (serverMember.getInstanceId() != null) {
                                        out.println(
                                            "          InstanceId     :"
                                                + serverMember.getInstanceId());
                                    }

                                }

                            }

                        }

                    }

                }

                out.println("    AvailabilityZones");

                if(work.getAvailabilityZones() != null) {

                    for(String work2 : work.getAvailabilityZones().getMember()) {
                        out.println("      member:" + work2);
                    }

                }

                out.println("    NetworkInterfaces");

                if (work.getNetworkInterfaces() != null) {

                    for (NetworkInterface network : work.getNetworkInterfaces()) {
                        out.println("      NetworkId   :" + network.getNetworkId());
                        out.println("      NetworkName :" + network.getNetworkName());
                        out.println(
                            "      DeviceIndex :" + Integer.toString(network.getDeviceIndex()));
                        out.println("      IpAddress   :" + network.getIpAddress());
                        out.println("      IsVipNetwork:" + network.getIsVipNetwork());
                        out.println("      Description :" + network.getDescription());

                        if (network.getSystemIpAddresses() != null) {
                            for (SystemIpAddress systemIpAddress: network.getSystemIpAddresses()) {
                                out.println("      SystemIpAddress:" + systemIpAddress.getSystemIpAddress());
                            }
                        }
                    }

                }

                out.println("    VersionInformation");

                if (work.getVersionInformation() != null) {

                    if (work.getVersionInformation().getLatest() != null) {
                        out.println("     Latest :" + work.getVersionInformation().getLatest());
                    }

                    if (work.getVersionInformation().getVersion() != null) {
                        out.println(
                            "      Version:" + work.getVersionInformation().getVersion());
                    }

                }

                if (work.getCreatedTime() != null) {
                    out.println("    CreatedTime:" + work.getCreatedTime());
                }
            }

            out.println(
                "=============================================================================");

        } catch (NiftyClientException ex) {
            err.println("Message: " + ex.getMessage());
        }
    }
}
